package com.arms.api.report.mail.controller.sender;

import com.arms.api.report.mail.modal.dto.sender.SenderDTO;
import com.arms.api.report.mail.modal.entity.sender.SenderEntity;
import com.arms.api.report.mail.service.sender.SenderService;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.annotation.PostConstruct;


@Slf4j
@Controller
@RequestMapping(value = {"/arms/report/mail-sender"})
public class SenderController extends TreeAbstractController<SenderService, SenderDTO, SenderEntity> {

    @Autowired
    @Qualifier("senderService")
    private SenderService senderService;

    @PostConstruct
    public void initialize() {
        setTreeService(senderService);
        setTreeEntity(SenderEntity.class);
    }



}
