package com.arms.api.report.mail.controller.receiver;

import com.arms.api.report.mail.modal.dto.receiver.ReceiverLogDTO;
import com.arms.api.report.mail.modal.entity.receiver.ReceiverLogEntity;
import com.arms.api.report.mail.service.receiver.ReceiverLog;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.annotation.PostConstruct;


@Slf4j
@Controller
@RequestMapping(value = {"/arms/report/mail-receiver-log"})
public class ReceiverLogController extends TreeAbstractController<ReceiverLog, ReceiverLogDTO, ReceiverLogEntity> {

    @Autowired
    @Qualifier("receiverLog")
    private ReceiverLog receiverLog;

    @PostConstruct
    public void initialize() {
        setTreeService(receiverLog);
        setTreeEntity(ReceiverLogEntity.class);
    }
}
