package com.arms.api.report.mail.controller;

import com.arms.api.report.mail.modal.vo.TopMenuResourceVO;
import com.arms.api.report.mail.modal.vo.TopMenuScopeVO;
import com.arms.api.report.mail.modal.vo.TopMenuTimeVO;
import com.arms.api.report.mail.service.mailreport.MailReportService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;


@Slf4j
@Controller
@RequestMapping(value = {"/arms/mail/report"})
public class MailReportController {

    @Autowired
    @Qualifier("mailReportService")
    private MailReportService mailReportService;

    @GetMapping("/top-menu/time")
    public ResponseEntity<TopMenuTimeVO> getTopMenuTime(){

        log.info(" [ MailReportController :: getTopMenuTime ] ");

        TopMenuTimeVO result = mailReportService.getTopMenuTime();

        return ResponseEntity.ok(result);
    }

    @GetMapping("/top-menu/scope")
    public ResponseEntity<TopMenuScopeVO> getTopMenuScope() throws Exception{

        log.info(" [ MailReportController :: getTopMenuScope ] ");

        TopMenuScopeVO result = mailReportService.getTopMenuScope();

        return ResponseEntity.ok(result);
    }

    @GetMapping("/top-menu/resource")
    public ResponseEntity<TopMenuResourceVO> getTopMenuResource() throws Exception{

        log.info(" [ MailReportController :: getTopMenuResource ] ");

        TopMenuResourceVO result = mailReportService.getTopMenuResource();

        return ResponseEntity.ok(result);
    }

}
