/*
 * @author Dongmin.lee
 * @since 2023-03-26
 * @version 23.03.26
 * @see <pre>
 *  Copyright (C) 2007 by 313 DEV GRP, Inc - All Rights Reserved
 *  Unauthorized copying of this file, via any medium is strictly prohibited
 *  Proprietary and confidential
 *  Written by 313 developer group <313@313.co.kr>, December 2010
 * </pre>
 */
package com.arms.api.jira.jiraissuetype.service;

import com.arms.api.jira.jiraissuestatus.model.JiraIssueStatusEntity;
import com.arms.api.jira.jiraissuetype.model.JiraIssueTypeEntity;
import com.arms.egovframework.javaservice.treeframework.service.TreeServiceImpl;
import lombok.AllArgsConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;


@AllArgsConstructor
@Service("jiraIssueType")
public class JiraIssueTypeImpl extends TreeServiceImpl implements JiraIssueType{

	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	public List<JiraIssueStatusEntity> getIssueStatusList(JiraIssueTypeEntity paramEntity) throws Exception {

		JiraIssueTypeEntity searchEntity = new JiraIssueTypeEntity();
		searchEntity.setC_id(paramEntity.getC_id());
		JiraIssueTypeEntity jiraIssueTypeEntity = this.getNode(searchEntity);

		List<JiraIssueStatusEntity> result = Optional.ofNullable(jiraIssueTypeEntity.getJiraIssueStatusEntities())
				.orElse(Collections.emptySet())
				.stream().collect(Collectors.toList());

		return result;
	}
}