package com.arms.api.dashboard.controller;

import com.arms.api.analysis.resource.model.dto.ResourceWithVersionIdNamesDTO;
import com.arms.api.analysis.resource.model.vo.treemap.TreeMapWorkerVO;
import com.arms.api.dashboard.model.dto.DashboardDTO;
import com.arms.api.dashboard.model.RequirementJiraIssueAggregationResponse;
import com.arms.api.dashboard.model.SankeyData;
import com.arms.api.dashboard.model.vo.Top5AssigneeReqStatusInfoVO;
import com.arms.api.dashboard.model.vo.TopNReqAssigneeVO;
import com.arms.api.dashboard.service.DashboardService;
import com.arms.api.util.GlobalConfig;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse.ApiResult;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@Slf4j
@RestController
@RequestMapping(value = "/arms/dashboard")
@RequiredArgsConstructor
public class DashboardController {

    private final DashboardService dashboardService;

    // Configuration 주입
    private final GlobalConfig globalConfig;

    // 생성자 주입
    /**
     * C3 Combination Chart API - Dashboard (좌하 - 우측)
     */
    @GetMapping("/aggregate-weekly-req-issue-status")
    public ResponseEntity<ApiResult<Map<String, RequirementJiraIssueAggregationResponse>>> requirementsJiraIssueStatuses(DashboardDTO dashboardDTO) {
        return ResponseEntity.ok(CommonResponse.success(dashboardService.requirementsJiraIssueStatuses(dashboardDTO)));
    }

    /**
     * D3 Sankey Chart API - Dashboard (우상 - 좌측)
     */
    @GetMapping(value="/version-assignee-summary", name="dashboard-version-assignee-summary")
    public ResponseEntity<ApiResult<SankeyData>> versionAssigneeIssueSummary(
            DashboardDTO dashboardDTO,
            @RequestParam(required = false) Integer topN) throws Exception {

        return ResponseEntity.ok(CommonResponse.success(dashboardService.sankeyChartAPIWithTopN(dashboardDTO, topN)));
    }

    /**
     * TreeMap Chart API - Dashboard (우상 - 우측)
     */
    @GetMapping(value ="/assignees-requirements-involvements-v3", name="dashboard-treemap-v3")
    ResponseEntity<ApiResult<List<TreeMapWorkerVO>>> findTreeMapChartDataV3(ResourceWithVersionIdNamesDTO resourceWithVersionIdNamesDTO) throws Exception {
        return ResponseEntity.ok(CommonResponse.success(dashboardService.findTreeMapChartDataV3(resourceWithVersionIdNamesDTO)));
    }

    /*
    *   투입 인력 진행 현황 - 인력별 요구사항 (Top 5) (우하 - 좌측)
    * */
    @GetMapping("/top-req-assignee")
    public ResponseEntity<ApiResult<List<TopNReqAssigneeVO>>> findTopNReqAssignee(
            DashboardDTO dashboardDTO,
            @RequestParam(required = false) Integer topN) {

        log.info("[ DashboardController :: findTopNReqAssignee ] :: top {}", topN);

        return  ResponseEntity.ok(CommonResponse.success(dashboardService.findTopNReqAssignee(dashboardDTO, topN)));
    }

    /*
    *   투입 인력 진행 현황 - 인력별 퍼포먼스 (Top 5) 인력별_요구사항_상태_누적_Top5 (우하 - 우측)
     * */
    @GetMapping("/top-req-state-info/{changeReqTableName}/getReqAddListByFilter")
    ResponseEntity<ApiResult< List<Top5AssigneeReqStatusInfoVO> >> findTopNAssigneeReqStateInfo(
            @PathVariable(value ="changeReqTableName") String changeReqTableName,
            DashboardDTO dashboardDTO,
            @RequestParam(required = false) Integer topN) throws Exception {

        return  ResponseEntity.ok(CommonResponse.success(dashboardService.findTopNAssigneeReqStateInfo(changeReqTableName, dashboardDTO, topN)));
    }

    @GetMapping("/global/config/test")
    public String getConfigTest() {
        return globalConfig.getConfigTest();
    }


}
