package com.arms.api.backoffice.system.systeminfo.controller;

import com.arms.api.backoffice.system.systeminfo.model.vo.SystemInfoVO;
import com.arms.api.util.communicate.external.GlobalConfigService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequestMapping("/arms/backoffice/system-info")
public class SystemInfoController {

    @Autowired
    private GlobalConfigService globalConfigService;

    @GetMapping("/getSystemInfo/org-link")
    @ResponseBody
    public ResponseEntity<SystemInfoVO> getSystemInfo(@RequestParam("orgLink") Long orgLink) {
        return ResponseEntity.ok(globalConfigService.getSystemInfo(orgLink));
    }
}
