package com.arms.api.backoffice.information.timeoff.model.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.List;

@Data
public class HolidayResponseDTO {
    private Response response;

    @Data
    public static class Response {
        private Body body;

        @Data
        public static class Body {

            private Items items;
            private int numOfRows;
            private int pageNo;
            private int totalCount;

            @Data
            public static class Items {
                @JsonFormat(with = JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY)
                private List<Item> item;

                @Data
                public static class Item {
                    private String dateKind;
                    private String dateName;
                    private String isHoliday;
                    private String locdate;
                    private int seq;
                }
            }
        }
    }
}
