package com.arms.api.analysis.cost.model.vo;

import com.arms.api.requirement.reqstatus.model.ReqStatusEntity;
import lombok.Getter;
import lombok.Setter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Setter
@Getter
public class LinkedJiraIssueVO {
    private Map<String, Map<Long, List<RequirementData>> > linkedJiraIssueData = new HashMap<>();

    @Getter
    @Setter
    public static class RequirementData {
        private Long c_id;
        private String c_title;
        private Long c_pdservice_link;
        private String c_pdservice_name;
        private Long c_pds_version_link;
        private String c_pds_version_name;
        private Long c_req_link;
        private String c_req_name;
        private String c_issue_key;
        private Long cost;
        private String c_req_pdservice_versionset_link;
    }
    public static RequirementData createRequirementData(ReqStatusEntity entity) {
        RequirementData RequirementData = new RequirementData();
        RequirementData.setC_id(entity.getC_id());
        RequirementData.setC_req_link(entity.getC_req_link());
        RequirementData.setC_issue_key(entity.getC_issue_key());
        RequirementData.setC_req_pdservice_versionset_link(entity.getC_req_pdservice_versionset_link());

        return RequirementData;
    }

}
