package com.arms.api.util.dynamicscheduler.service;

import com.arms.api.jira.jiraproject.model.JiraProjectEntity;
import com.arms.api.jira.jiraproject.service.JiraProject;
import com.arms.api.jira.jiraserver.model.JiraServerEntity;
import com.arms.api.requirement.reqadd.model.dto.ReqAddDTO;
import com.arms.api.requirement.reqstatus.model.ReqStatusDTO;
import com.arms.api.requirement.reqstatus.model.ReqStatusEntity;
import com.arms.api.requirement.reqstatus.service.ReqStatus;
import com.arms.api.util.aspect.DwrSendAlarm;
import com.arms.api.util.aspect.MailSendAlarm;
import com.arms.api.util.aspect.SlackSendAlarm;
import com.arms.api.util.communicate.external.EngineService;
import com.arms.api.util.communicate.external.response.jira.AlmIssue;
import com.arms.api.util.communicate.external.response.jira.CReqProperty;
import com.arms.api.util.communicate.external.response.jira.지라이슈생성_데이터;
import com.arms.api.util.communicate.external.response.jira.지라이슈필드_데이터;
import com.arms.api.util.communicate.internal.InternalService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.modelmapper.ModelMapper;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.*;

import static com.arms.egovframework.javaservice.treeframework.TreeConstant.REQADD_PREFIX_TABLENAME;
import static com.arms.egovframework.javaservice.treeframework.TreeConstant.REQSTATUS_PREFIX_TABLENAME;

@Slf4j
@Service
@RequiredArgsConstructor
public class ReqStatusSyncServiceImpl implements ReqStatusSyncService {

    private final InternalService internalService;

    private final JiraProject jiraProject;

    private final ModelMapper modelMapper;

    private final EngineService engineService;

    private final ReqStatus reqStatus;

    @Async
    @Override
    @DwrSendAlarm(messageOnStart = "ALM 요구사항 이슈 동기화를 시작 합니다.(ALM TO DB)",messageOnEnd = "ALM 요구사항 이슈 동기화가 완료 되었습니다.(ALM TO DB)")
    @SlackSendAlarm(messageOnStart = "ALM 요구사항 이슈 동기화를 시작 합니다.(ALM TO DB)",messageOnEnd = "ALM 요구사항 이슈 동기화가 완료 되었습니다.(ALM TO DB)")
    public void 엔진수집결과_동기화(List<AlmIssue> almIssues) throws Exception {

        String logMessagePrefix = "[ ReqStatusSyncService :: 이슈동기화_ReqStatus업데이트 ]";

        List<JiraProjectEntity> jiraProjectEntities = jiraProject.getNodesWithoutRoot(new JiraProjectEntity());

        List<ReqStatusEntity> updatedReqStatusEntities = new ArrayList<>();

        almIssues.stream()
            .filter(jiraIssue->jiraIssue != null && jiraIssue.getRecentId() != null)
            .forEach(jiraIssue -> {
                ReqStatusDTO reqStatusDTO = new ReqStatusDTO();
                reqStatusDTO.setC_id(jiraIssue.getCReqStatusId());

                List<ReqStatusEntity> reqStatusEntities
                    = internalService.getStatusNode(REQSTATUS_PREFIX_TABLENAME + jiraIssue.getPdServiceId(), reqStatusDTO).getBody();

                if (reqStatusEntities == null || reqStatusEntities.isEmpty()) {
                    log.info("{} :: ReqStatus 조회 결과 없음. pdServiceId = {}, cReqStatusId = {}",
                            logMessagePrefix, jiraIssue.getPdServiceId(), jiraIssue.getCReqStatusId());
                    return;
                }

                reqStatusEntities.forEach(reqStatusEntity -> {

                    Optional<JiraProjectEntity> optionalJiraProjectEntity = jiraProjectEntities.stream()
                            .filter(project -> project.getC_jira_key().equals(jiraIssue.getProject().getKey()))
                            .findFirst();

                    optionalJiraProjectEntity.ifPresent(jiraProjectEntity -> {

                        if (isReqStatusNeedsUpdate(reqStatusEntity, jiraIssue)) {

                            boolean issueNameMisMatch = reqStatusEntity.getC_title() != null
                                    && !reqStatusEntity.getC_title().equals(jiraIssue.getSummary());

                            if(issueNameMisMatch){
                                updatedReqStatusEntities.add(reqStatusEntity);
                            }

                            reqStatusEntity.setC_jira_project_link(jiraProjectEntity.getC_id());
                            reqStatusEntity.setC_jira_project_url(jiraProjectEntity.getC_jira_url());
                            reqStatusEntity.setC_jira_project_name(jiraProjectEntity.getC_jira_name());
                            reqStatusEntity.setC_jira_project_key(jiraProjectEntity.getC_jira_key());
                            reqStatusEntity.setC_issue_key(jiraIssue.getKey());
                            reqStatusEntity.setC_issue_update_date(new Date());
                            reqStatusEntity.setC_title(jiraIssue.getSummary());

                            internalService.요구사항_상황_수정하기(
                                    REQSTATUS_PREFIX_TABLENAME + jiraIssue.getPdServiceId(),
                                    modelMapper.map(reqStatusEntity, ReqStatusDTO.class)
                            );

                            log.info("{} :: ReqStatus 업데이트 완료. issueKey = {}, projectKey = {}",
                                    logMessagePrefix, jiraIssue.getKey(), jiraIssue.getProject().getKey());
                        }

                    });
                });
             });

        for (ReqStatusEntity updatedReqStatusEntity : updatedReqStatusEntities) {
            ReqStatusDTO reqStatusDTO = new ReqStatusDTO();
            reqStatusDTO.setC_req_link(updatedReqStatusEntity.getC_req_link());
            List<ReqStatusEntity> reqStatusEntities
                    = internalService.REQSTATUS_CID_요구사항_이슈_조회(REQSTATUS_PREFIX_TABLENAME + updatedReqStatusEntity.getC_pdservice_link(), reqStatusDTO).getBody();

            if(reqStatusEntities!=null){
                reqStatusEntities
                    .stream()
                    .max(Comparator.comparing(ReqStatusEntity::getC_issue_update_date)).stream().findFirst()
                        .ifPresent(reqStatusEntity -> {
                            String cTitle = reqStatusEntity.getC_title();
                            reqStatusEntities.stream().filter(a->!reqStatusEntity.getC_id().equals(a.getC_id()))
                                .forEach(updateReqStatusEntity->{
                                    ReqStatusDTO updatedReqStatusDTO = new ReqStatusDTO();
                                    updatedReqStatusDTO.setC_id(updateReqStatusEntity.getC_id());
                                    updatedReqStatusDTO.setC_title(cTitle);
                                    internalService.요구사항_상황_수정하기(REQSTATUS_PREFIX_TABLENAME + updatedReqStatusEntity.getC_pdservice_link(),updatedReqStatusDTO);

                                    지라이슈필드_데이터.지라이슈필드_데이터Builder 요구사항이슈_필드빌더 = 지라이슈필드_데이터
                                            .builder()
                                            .summary(cTitle);

                                    지라이슈필드_데이터 요구사항이슈_필드 = 요구사항이슈_필드빌더.build();
                                    지라이슈생성_데이터 요구사항_이슈 = 지라이슈생성_데이터
                                            .builder()
                                            .fields(요구사항이슈_필드)
                                            .build();

                                    JiraServerEntity jiraServerEntity = reqStatus.ALM서버_검색(updateReqStatusEntity.getC_jira_server_link());
                                    engineService.이슈_수정하기(Long.parseLong(jiraServerEntity.getC_jira_server_etc()), updateReqStatusEntity.getC_issue_key(), 요구사항_이슈);
                                    engineService.saveRequirementIssueKeyOnlyFirst(
                                            jiraServerEntity.getC_jira_server_etc(),
                                            cTitle,
                                            updateReqStatusEntity.getC_id(),
                                            updateReqStatusEntity.getC_issue_key(),
                                            updateReqStatusEntity.getC_pdservice_link(),
                                            convertVersionToArray(updateReqStatusEntity.getC_req_pdservice_versionset_link()),
                                            updateReqStatusEntity.getC_req_link(),
                                            updateReqStatusEntity.getC_jira_project_key(),
                                            CReqProperty.of(updateReqStatusEntity)
                                    );
                                });
                            ReqAddDTO reqAddDTO = new ReqAddDTO();
                            reqAddDTO.setC_id(reqStatusEntity.getC_req_link());
                            reqAddDTO.setC_title(cTitle);
                            internalService.요구사항_수정하기(REQADD_PREFIX_TABLENAME + updatedReqStatusEntity.getC_pdservice_link(),reqAddDTO);
                        });
            }

        }

    }

    private boolean isReqStatusNeedsUpdate(ReqStatusEntity reqStatusEntity, AlmIssue jiraIssue) {
        boolean issueKeyMismatch = reqStatusEntity.getC_issue_key() != null
                && !reqStatusEntity.getC_issue_key().equals(jiraIssue.getKey());

        boolean projectKeyMismatch = reqStatusEntity.getC_jira_project_key() != null
                && !reqStatusEntity.getC_jira_project_key().equals(jiraIssue.getProject().getKey());

        boolean issueNameMisMatch = reqStatusEntity.getC_title() != null
                && !reqStatusEntity.getC_title().equals(jiraIssue.getSummary());

        return issueKeyMismatch || projectKeyMismatch || issueNameMisMatch;
    }

    private Long[] convertVersionToArray(String versionList) {
        return Arrays.stream(versionList.split("[\\[\\],\"]"))
                .filter(s -> !s.isEmpty())
                .map(Long::valueOf)
                .toArray(Long[]::new);
    }
}