package com.arms.api.requirement.reqstatus_calendar.model;


import com.arms.egovframework.javaservice.treeframework.excel.ExcelClassAnnotation;
import com.arms.egovframework.javaservice.treeframework.excel.ExcelFieldAnnotation;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@ExcelClassAnnotation(sheetName = "Sheet2", headerRowSize = 1, headerTitleName = "이슈 데이터 정보")
@ToString
public class CalendarDataDTO {

    private Long pdServiceId; // 히든

    @ExcelFieldAnnotation(columnIndex = 0, formatting = "%.0f", headerName = "제품(서비스)")
    private String pdServiceName;

    private Long[] pdServiceVersions; // 히든

    @ExcelFieldAnnotation(columnIndex = 1, formatting = "%.0f", headerName = "버전(일정)")
    private String pdServiceVersionNames;

    private Boolean isReq; // 히든

    private String etc; // 히든

    private String docId; // 히든

    private String issueID; //-> 원래 issueId 였으나 docId로 대체될 필드

    @ExcelFieldAnnotation(columnIndex = 4, formatting = "%.0f", headerName = "ALM 이슈 키")
    private String key;

    private String parentReqKey; // 히든

    private String upperKey; // 히든

    @ExcelFieldAnnotation(columnIndex = 3, formatting = "%.0f", headerName = "ALM 이슈 구분")
    private String isReqName;

    @ExcelFieldAnnotation(columnIndex = 2, formatting = "%.0f", headerName = "ALM Project") // 2
    private String almProjectName;

    private Long cReqLink; // 히든

    @ExcelFieldAnnotation(columnIndex = 5, formatting = "%.0f", headerName = "A-RMS 요구사항")
    private String reqTitle;

    @ExcelFieldAnnotation(columnIndex = 6, formatting = "%.0f", headerName = "A-RMS 요구사항 상태")
    private String reqState;

    @ExcelFieldAnnotation(columnIndex = 7, formatting = "%.0f", headerName = "ALM 이슈 제목")
    private String issueTitle;

    @ExcelFieldAnnotation(columnIndex = 8, formatting = "%.0f", headerName = "ALM 이슈 상태")
    private String issueStatus;

    @ExcelFieldAnnotation(columnIndex = 9, formatting = "%.0f", headerName = "ALM 이슈 담당자")
    private String assigneeName;

    @ExcelFieldAnnotation(columnIndex = 10, formatting = "%.0f", headerName = "ALM 이슈 담당자 메일")
    private String assigneeEmail;

    @ExcelFieldAnnotation(columnIndex = 11, formatting = "%.0f", headerName = "ALM 이슈 생성일")
    private String createDate;

    @ExcelFieldAnnotation(columnIndex = 12, formatting = "%.0f", headerName = "ALM 이슈 수정일")
    private String updatedDate;

    @ExcelFieldAnnotation(columnIndex = 13, formatting = "%.0f", headerName = "ALM 이슈 해결일")
    private String resolutionDate;

    @ExcelFieldAnnotation(columnIndex = 14, formatting = "%.0f", headerName = "ALM 이슈 삭제일")
    private String deletedDate;
}

