/*
 * @author Dongmin.lee
 * @since 2022-11-20
 * @version 22.11.20
 * @see <pre>
 *  Copyright (C) 2007 by 313 DEV GRP, Inc - All Rights Reserved
 *  Unauthorized copying of this file, via any medium is strictly prohibited
 *  Proprietary and confidential
 *  Written by 313 developer group <313@313.co.kr>, December 2010
 * </pre>
 */
package com.arms.api.product_service.pdserviceversion.controller;

import java.util.List;

import javax.annotation.PostConstruct;

import com.arms.api.product_service.pdserviceversion.model.PdServiceVersionVO;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.arms.api.product_service.pdserviceversion.model.PdServiceVersionDTO;
import com.arms.api.product_service.pdserviceversion.model.PdServiceVersionEntity;
import com.arms.api.product_service.pdserviceversion.service.PdServiceVersion;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;


@Slf4j
@RestController
@RequiredArgsConstructor
@RequestMapping(value = {"/arms/pdServiceVersion"})
public class PdServiceVersionController extends TreeAbstractController<PdServiceVersion, PdServiceVersionDTO, PdServiceVersionEntity> {

    private final PdServiceVersion pdServiceVersion;

    @PostConstruct
    public void initialize() {
        setTreeService(pdServiceVersion);
        setTreeEntity(PdServiceVersionEntity.class);
    }

    /**
     * Dashboard, TopMenu
     */
    @GetMapping
    public ResponseEntity<?> getVersion(@RequestParam("c_ids") List<Long> c_ids) throws Exception {

        log.info("[ PdServiceVersionController :: getVersionListByAjax ] :: 버전아이디 수 => {}", c_ids.size());
        return ResponseEntity.ok(CommonResponse.success(pdServiceVersion.getVersionListByCids(c_ids)));
    }

    @GetMapping("/pure")
    public ResponseEntity<?> findAll(@RequestParam("c_id") Long c_id) throws Exception {

        log.info("[ PdServiceVersionController :: findAll ]");

        List<PdServiceVersionVO> response = pdServiceVersion.findAllByPdServiceId(c_id);

        return ResponseEntity.ok(CommonResponse.success(response));
    }
}
