package com.arms.api.patchnote.controller;

import com.arms.api.patchnote.model.PatchnoteDTO;
import com.arms.api.patchnote.model.PatchnoteEntity;
import com.arms.api.patchnote.service.PatchnoteService;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.annotation.PostConstruct;

@Slf4j
@Controller
@RestController
@RequiredArgsConstructor
@RequestMapping(value = {"/arms/patchnote"})
public class AdminPatchController extends TreeAbstractController<PatchnoteService, PatchnoteDTO, PatchnoteEntity> {

    private final PatchnoteService patchnoteService;

    @PostConstruct
    public void initialize() {
        setTreeService(patchnoteService);
        setTreeEntity(PatchnoteEntity.class);
    }

    @PostMapping("/addPatchnote.do")
    public ResponseEntity<PatchnoteEntity> addPatchnote(@RequestBody PatchnoteDTO patchnoteDTO) throws Exception {
        log.info("[ PatchnoteController :: addPatchnote ] {}", patchnoteDTO);
        return ResponseEntity.ok(patchnoteService.addPatchnote(patchnoteDTO));
    }

    @PutMapping("/updatePatchnote.do")
    public ResponseEntity<PatchnoteEntity> updatePatchnote(@RequestBody PatchnoteDTO patchnoteDTO) throws Exception {
        log.info("[ PatchnoteController :: updatePatchnote ] {}", patchnoteDTO);
        return ResponseEntity.ok(patchnoteService.updatePatchnote(patchnoteDTO));
    }

    // deletePatchnote()는 TreeAbstractController에서 제공하는 deleteNode() 사용

}
