package com.arms.api.newsletter.model;

import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import org.hibernate.annotations.*;
import org.hibernate.annotations.Cache;

import javax.persistence.*;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

@Entity
@Getter
@Setter
@Builder
@Table(name = "T_ARMS_NEWSLETTER")
@SelectBeforeUpdate(value = true)
@DynamicInsert(value = true)
@DynamicUpdate(value = true)
@Cache(usage = CacheConcurrencyStrategy.NONE)
@NoArgsConstructor
@AllArgsConstructor
public class NewsletterEntity extends TreeSearchEntity implements Serializable {

    @Override
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "c_id")
    public Long getC_id() {
        return super.getC_id();
    }

    //@Getter @Setter
    @Column(name = "c_newsletter_category")
    private String c_newsletter_category;

    @Column(name = "c_newsletter_title")
    private String c_newsletter_title;

    @Column(name = "c_newsletter_subtitle")
    private String c_newsletter_subtitle;

    @Column(name = "c_newsletter_author_id")
    private String c_newsletter_author_id;

    @Column(name = "c_newsletter_author_name")
    private String c_newsletter_author_name;

    @CreationTimestamp
    @Column(name = "c_newsletter_created")
    private LocalDateTime c_newsletter_created;

    @UpdateTimestamp
    @Column(name = "c_newsletter_updated")
    private LocalDateTime c_newsletter_updated;

    @Column(name = "c_newsletter_visibility")
    private String c_newsletter_visibility;

    @Column(name = "c_newsletter_hit")
    private Integer c_newsletter_hit;

    @Column(name = "c_newsletter_slug")
    private String c_newsletter_slug; // URL-friendly identifier

    @Column(name = "c_newsletter_thumbnail_url")
    private String c_newsletter_thumbnail_url;

    @Column(name = "c_newsletter_thumbnail_alt")
    private String c_newsletter_thumbnail_alt;

    @Column(name = "c_newsletter_etc")
    private String c_newsletter_etc;

    @Type(type = "text")
    @Column(name = "c_newsletter_desc")
    private String c_newsletter_desc;

    @Lob
    @Column(name = "c_newsletter_contents")
    private String c_newsletter_contents;


    /*
     * Extend Bean Field
     */
    @JsonIgnore
    private Boolean copyBooleanValue;

    @Transient
    @ApiModelProperty(hidden = true)
    public Boolean getCopyBooleanValue() {
        copyBooleanValue = false;
        if (this.getCopy() == 0) {
            copyBooleanValue = false;
        } else {
            copyBooleanValue = true;
        }
        return copyBooleanValue;
    }

    public void setCopyBooleanValue(Boolean copyBooleanValue) {
        this.copyBooleanValue = copyBooleanValue;
    }

    @Override
    public <T extends TreeSearchEntity> void setFieldFromNewInstance(T paramInstance) {
        if (paramInstance instanceof TreeSearchEntity) {
            if (paramInstance.isCopied()) {
                this.setC_title("copy_" + this.getC_title());
            }
        }
    }
}
