package com.arms.api.jira.jiraserver_project_pure.service;

import com.arms.api.jira.jiraproject_issuetype_pure.model.JiraProjectIssueTypePureEntity;
import com.arms.api.jira.jiraserver_project_pure.model.ALMServerProjectPureWithDateVO;
import com.arms.api.jira.jiraserver_project_pure.model.JiraServerProjectPureEntity;
import com.arms.api.util.communicate.external.EngineService;
import com.arms.api.util.communicate.external.request.ServerInfo;
import com.arms.egovframework.javaservice.treeframework.service.TreeServiceImpl;
import lombok.AllArgsConstructor;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@AllArgsConstructor
@Service("jiraServerProjectPure")
public class JiraServerProjectPureImpl extends TreeServiceImpl implements JiraServerProjectPure {

    private final EngineService engineService;

    @Override
    public JiraServerProjectPureEntity getNodeWithoutSoftDelete(JiraServerProjectPureEntity jiraServerProjectPureEntity) throws Exception {
        JiraServerProjectPureEntity result = this.getNode(jiraServerProjectPureEntity);

        if (result == null) {
            return result;
        }

        return 엔티티별_소프트_딜리트_제외(result);
    }

    @Override
    public List<ALMServerProjectPureWithDateVO> getNodesWithoutRootAndSoftDeleteWithDate(JiraServerProjectPureEntity jiraServerProjectPureEntity) throws Exception {
        List<JiraServerProjectPureEntity> jiraServerProjectPureEntities = this.getNodesWithoutRoot(jiraServerProjectPureEntity);

        List<JiraServerProjectPureEntity> entitiesWithoutSoftDelete = Optional.ofNullable(jiraServerProjectPureEntities)
                .orElseGet(Collections::emptyList)
                .stream()
                .filter(Objects::nonNull)
                .map(this::엔티티별_소프트_딜리트_제외)
                .collect(Collectors.toList());

        List<ServerInfo> serverInfo = getServerInfoListExceptIdAndToken(entitiesWithoutSoftDelete);

        // entity 설정
        return entitiesWithoutSoftDelete.stream()
            .map(entity -> {
                ServerInfo matchingServerInfo = serverInfo.stream()
                        .filter(info -> Objects.equals(info.getConnectId(), entity.getC_jira_server_etc()))
                        .findFirst()
                        .orElse(null);
                return ALMServerProjectPureWithDateVO.builder()
                        .jiraServerProjectPureEntity(entity) // entity 설정
                        .createdDate(matchingServerInfo != null ? matchingServerInfo.getCreatedDate() : null)
                        .updatedDate(matchingServerInfo != null ? matchingServerInfo.getUpdatedDate() : null)
                        .build();
            })
            .collect(Collectors.toList());
    }

    private List<ServerInfo> getServerInfoListExceptIdAndToken(List<JiraServerProjectPureEntity> entitiesWithoutSoftDelete) {
        List<String> uniqueConnectIdValues = entitiesWithoutSoftDelete.stream()
                .map(JiraServerProjectPureEntity::getC_jira_server_etc)
                .filter(Objects::nonNull)
                .distinct()
                .collect(Collectors.toList());
        return engineService.serverInfoListByConnectIds(uniqueConnectIdValues);
    }

    public JiraServerProjectPureEntity 엔티티별_소프트_딜리트_제외(JiraServerProjectPureEntity jiraServerProjectPureEntity) {
        프로젝트_및_프로젝트별_이슈타입_소프트딜리트_제외(jiraServerProjectPureEntity);
        전역_이슈타입_소프트딜리트_제외(jiraServerProjectPureEntity);
        전역_이슈_우선순위_소프트딜리트_제외(jiraServerProjectPureEntity);

        return jiraServerProjectPureEntity;
    }

    private void 프로젝트_및_프로젝트별_이슈타입_소프트딜리트_제외(JiraServerProjectPureEntity jiraServerProjectPureEntity) {
        if (jiraServerProjectPureEntity.getJiraProjectIssueTypePureEntities() != null) {
            jiraServerProjectPureEntity.setJiraProjectIssueTypePureEntities(
                    프로젝트_소프트딜리트_제외(jiraServerProjectPureEntity.getJiraProjectIssueTypePureEntities())
            );
        }
    }

    private Set<JiraProjectIssueTypePureEntity> 프로젝트_소프트딜리트_제외(Set<JiraProjectIssueTypePureEntity> projects) {
        return Optional.ofNullable(projects)
                .orElseGet(Collections::emptySet)
                .stream()
                .filter(Objects::nonNull)
                .filter(project -> project.getC_etc() == null
                                        || !StringUtils.equals(project.getC_etc(), "delete"))
                .map(project -> {
                        프로젝트별_이슈타입_소프트딜리트_제외(project);
                        return project;
                })
                .collect(Collectors.toSet());
    }

    private void 프로젝트별_이슈타입_소프트딜리트_제외(JiraProjectIssueTypePureEntity project) {
            project.setJiraIssueTypePureEntities(
                    Optional.ofNullable(project.getJiraIssueTypePureEntities())
                    .orElseGet(Collections::emptySet)
                    .stream()
                    .filter(Objects::nonNull)
                    .filter(issuetype -> issuetype.getC_etc() == null
                            || !StringUtils.equals(issuetype.getC_etc(), "delete"))
                    .collect(Collectors.toSet())
            );
    }

    private void 전역_이슈타입_소프트딜리트_제외(JiraServerProjectPureEntity jiraServerProjectPureEntity) {
        jiraServerProjectPureEntity.setJiraIssueTypePureEntities(
                Optional.ofNullable(jiraServerProjectPureEntity.getJiraIssueTypePureEntities())
                .orElseGet(Collections::emptySet)
                .stream()
                .filter(issueType -> issueType.getC_etc() == null
                        || !StringUtils.equals(issueType.getC_etc(), "delete"))
                .collect(Collectors.toSet())
        );
    }

    private void 전역_이슈_우선순위_소프트딜리트_제외(JiraServerProjectPureEntity jiraServerProjectPureEntity) {
        jiraServerProjectPureEntity.setJiraIssuePriorityEntities(
                Optional.ofNullable(jiraServerProjectPureEntity.getJiraIssuePriorityEntities())
                .orElseGet(Collections::emptySet)
                .stream()
                .filter(issuePriority -> issuePriority.getC_etc() == null
                        || !StringUtils.equals(issuePriority.getC_etc(), "delete"))
                .collect(Collectors.toSet())
        );
    }

    @Override
    public List<JiraProjectIssueTypePureEntity> 서버_프로젝트_가져오기(JiraServerProjectPureEntity jiraServerProjectPureEntity) throws Exception {

        JiraServerProjectPureEntity result = this.getNode(jiraServerProjectPureEntity);

        if (result == null || result.getJiraProjectIssueTypePureEntities() == null) {
            return Collections.emptyList();
        }

        return result.getJiraProjectIssueTypePureEntities()
                .stream()
                .filter(project -> project.getC_etc() == null
                        || !StringUtils.equals(project.getC_etc(), "delete"))
                .collect(Collectors.toList());
    }
}
