/*
 * @author Dongmin.lee
 * @since 2023-03-28
 * @version 23.03.28
 * @see <pre>
 *  Copyright (C) 2007 by 313 DEV GRP, Inc - All Rights Reserved
 *  Unauthorized copying of this file, via any medium is strictly prohibited
 *  Proprietary and confidential
 *  Written by 313 developer group <313@313.co.kr>, December 2010
 * </pre>
 */
package com.arms.api.jira.jiraserver.service;

import com.arms.api.jira.jiraissuepriority.model.JiraIssuePriorityEntity;
import com.arms.api.jira.jiraissueresolution.model.JiraIssueResolutionEntity;
import com.arms.api.jira.jiraissuestatus.model.JiraIssueStatusEntity;
import com.arms.api.jira.jiraissuestatus.model.StatusRuleSetEntity;
import com.arms.api.jira.jiraissuetype.model.JiraIssueTypeEntity;
import com.arms.api.jira.jiraproject_pure.model.JiraProjectPureEntity;
import com.arms.api.jira.jiraserver.model.JiraServerEntity;
import com.arms.api.jira.jiraserver.model.enums.EntityType;
import com.arms.egovframework.javaservice.treeframework.service.TreeService;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface JiraServer extends TreeService {

    JiraServerEntity addJiraServer(JiraServerEntity jiraServerEntity) throws Exception;

    JiraServerEntity 서버_엔티티_항목별_갱신(EntityType 갱신할_항목, String 프로젝트_C아이디, JiraServerEntity jiraServerEntity) throws Exception;

    List<JiraProjectPureEntity> getProjectPureList(JiraServerEntity jiraServerEntity) throws Exception;

    List<JiraIssueTypeEntity> getIssueTypeOnlyList(JiraServerEntity jiraServerEntity) throws Exception;

    List<JiraIssueStatusEntity> getServerIssueStatusOnlyList(JiraServerEntity jiraServerEntity) throws Exception;

    List<JiraIssuePriorityEntity> getServerIssuePriorityOnlyList(JiraServerEntity jiraServerEntity) throws Exception;

    List<JiraIssueResolutionEntity> getServerIssueResolutionList(JiraServerEntity jiraServerEntity) throws Exception;

    JiraServerEntity setDefaultValueForTarget(EntityType 설정할_항목, Long 항목_c_id, JiraServerEntity jiraServerEntity) throws Exception;

    int updateArmsAndEngineServerData(JiraServerEntity jiraServerEntity) throws Exception;

    CompletableFuture<Boolean> refreshALMServer(JiraServerEntity jiraServerEntity) throws Exception;

    Map<String, Map<String, StatusRuleSetEntity>> getStatusRuleSet(JiraServerEntity jiraServer) throws Exception;

    void preSetIssueStatusMapping(String 프로젝트_C아이디 ,JiraServerEntity jiraServer)throws Exception;

    void cacheStatusMappingData(JiraServerEntity jiraServerEntity) throws Exception;
}