/*
 * @author Dongmin.lee
 * @since 2023-03-20
 * @version 23.03.20
 * @see <pre>
 *  Copyright (C) 2007 by 313 DEV GRP, Inc - All Rights Reserved
 *  Unauthorized copying of this file, via any medium is strictly prohibited
 *  Proprietary and confidential
 *  Written by 313 developer group <313@313.co.kr>, December 2010
 * </pre>
 */
package com.arms.api.dwralarm.controller;

import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.remote.Chat;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;


@Slf4j
@RestController
@RequestMapping(value = {"/arms/alarm"})
@AllArgsConstructor
public class AlarmController {

    private final Chat chat;

    @PostMapping(value = "/send-message")
    public ResponseEntity<CommonResponse.ApiResult<String>> sendMessage(@RequestParam("message") String message)  {
        try{
            chat.sendMessageByEngine(message);
        }catch (Exception e){
            log.warn("dwr session is null");
        }
        return ResponseEntity.ok(CommonResponse.success("OK"));
    }

    @PostMapping(value = "/send-message/server")
    public ResponseEntity<CommonResponse.ApiResult<String>> sendMessageByServer(@RequestParam("message") String message)  {
        chat.sendMessageByServer(message);
        return ResponseEntity.ok(CommonResponse.success("OK"));
    }

}
