package com.arms.api.dashboard.service;

import com.arms.api.analysis.resource.model.dto.ResourceWithVersionIdNamesDTO;
import com.arms.api.analysis.resource.model.vo.treemap.TreeMapWorkerVO;
import com.arms.api.dashboard.model.RequirementJiraIssueAggregationResponse;
import com.arms.api.dashboard.model.SankeyData;
import com.arms.api.dashboard.model.dto.DashboardDTO;
import com.arms.api.dashboard.model.vo.Top5AssigneeReqStatusInfoVO;
import com.arms.api.dashboard.model.vo.TopNReqAssigneeVO;

import java.util.List;
import java.util.Map;

public interface DashboardService {

    Map<String, RequirementJiraIssueAggregationResponse> requirementsJiraIssueStatuses(DashboardDTO dashboardDTO);

    // (resource) sankey - 우상단
    SankeyData sankeyChartAPIWithTopN(DashboardDTO dashboardDTO, Integer topN) throws Exception;
    // (resource) treemap - 우상단
    List<TreeMapWorkerVO> findTreeMapChartDataV3(ResourceWithVersionIdNamesDTO resourceWithVersionIdNamesDTO) throws Exception;
    // (resource) bar - 우하단 (왼쪽)
    List<TopNReqAssigneeVO> findTopNReqAssignee(DashboardDTO dashboardDTO, Integer topN);
    // (resource) polar-bar - 우하단 (오른쪽)
    List<Top5AssigneeReqStatusInfoVO> findTopNAssigneeReqStateInfo(String changeReqTableName, DashboardDTO dashboardDTO, Integer topN) throws Exception;

}
