package com.arms.api.blog.model;

import com.arms.egovframework.javaservice.treeframework.model.TreeBaseEntity;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import org.hibernate.annotations.*;
import org.hibernate.annotations.Cache;

import javax.persistence.*;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

@Entity
@Getter
@Setter
@Builder
@Table(name = "T_ARMS_BLOG")
@SelectBeforeUpdate(value=true)
@DynamicInsert(value=true)
@DynamicUpdate(value=true)
@Cache(usage = CacheConcurrencyStrategy.NONE)
@NoArgsConstructor
@AllArgsConstructor
public class BlogEntity extends TreeSearchEntity implements Serializable {

    @Override
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "c_id")
    public Long getC_id() {
        return super.getC_id();
    }

    @Column(name = "c_parentid", nullable = false)
    private Long c_parentid;

    @Column(name = "c_position", nullable = false)
    private Long c_position;

    @Column(name = "c_left", nullable = false)
    private Long c_left;

    @Column(name = "c_right", nullable = false)
    private Long c_right;

    @Column(name = "c_level", nullable = false)
    private Long c_level;

    @Column(name = "c_title")
    private String c_title;

    @Column(name = "c_type")
    private String c_type;

    @Column(name = "c_blog_category")
    private String c_blog_category;

    @Column(name = "c_blog_title")
    private String c_blog_title;

    @Column(name = "c_blog_subtitle")
    private String c_blog_subtitle;

    @Column(name = "c_blog_author_id")
    private String c_blog_author_id;

    @Column(name = "c_blog_author_name")
    private String c_blog_author_name;

    @Column(name = "c_blog_created")
    private Date c_blog_created;

    @Column(name = "c_blog_updated")
    private Date c_blog_updated;

    @Column(name = "c_blog_visibility")
    private String c_blog_visibility;

    @Column(name = "c_blog_slug")
    private String c_blog_slug;

    @Column(name = "c_blog_thumbnail_url")
    private String c_blog_thumbnail_url;

    @Column(name = "c_blog_etc")
    private String c_blog_etc;

    @Lob
    @Column(name = "c_blog_desc")
    private String c_blog_desc;

    @Lob
    @Column(name = "c_blog_contents")
    private String c_blog_contents;

    /*
     * Extend Bean Field
     */
    @JsonIgnore
    private Boolean copyBooleanValue;

    @Transient
    @ApiModelProperty(hidden = true)
    public Boolean getCopyBooleanValue() {
        copyBooleanValue = false;
        if (this.getCopy() == 0) {
            copyBooleanValue = false;
        } else {
            copyBooleanValue = true;
        }
        return copyBooleanValue;
    }

    public void setCopyBooleanValue(Boolean copyBooleanValue) {
        this.copyBooleanValue = copyBooleanValue;
    }

    @Override
    public <T extends TreeSearchEntity> void setFieldFromNewInstance(T paramInstance) {
        if( paramInstance instanceof TreeBaseEntity){
            if(paramInstance.isCopied()) {
                this.setC_title("copy_" + this.getC_title());
            }
        }
    }
}
