package com.arms.api.blog.model;

import com.arms.egovframework.javaservice.treeframework.model.TreeBaseDTO;
import lombok.*;
import lombok.experimental.SuperBuilder;
import org.springframework.web.multipart.MultipartFile;

import java.time.LocalDateTime;
import java.util.Date;

@Getter
@Setter
@Builder
@ToString(callSuper=true)
@NoArgsConstructor
@AllArgsConstructor
public class BlogDTO extends TreeBaseDTO {

    private String c_blog_category;
    private String c_blog_title;
    private String c_blog_subtitle;
    private String c_blog_author_id;
    private String c_blog_author_name;
    private Date c_blog_created;
    private Date c_blog_updated;
    private String c_blog_visibility;
    private String c_blog_slug;
    private String c_blog_thumbnail_url;
    private String c_blog_etc;
    private String c_blog_desc;
    private String c_blog_contents;
    private Integer c_blog_view_count;

    public BlogEntity createEntity () {
        BlogEntity blogEntity = BlogEntity.builder()
                .c_blog_category(this.c_blog_category)
                .c_blog_title(this.c_blog_title)
                .c_blog_subtitle(this.c_blog_subtitle)
                .c_blog_author_id(this.c_blog_author_id)
                .c_blog_author_name(this.c_blog_author_name)
                .c_blog_created(this.c_blog_created)
                .c_blog_updated(this.c_blog_updated)
                .c_blog_visibility(this.c_blog_visibility)
                .c_blog_slug(this.c_blog_slug)
                .c_blog_thumbnail_url(this.c_blog_thumbnail_url)
                .c_blog_etc(this.c_blog_etc)
                .c_blog_desc(this.c_blog_desc)
                .c_blog_contents(this.c_blog_contents)
                .build();
        blogEntity.setC_id(this.getC_id()); // 참조가 안되어 수동 setter
        return blogEntity;
    }
}
