--
-- Update table `T_ARMS_REQSTATE`
--
UPDATE `aRMS`.`T_ARMS_REQSTATE` SET C_CHECK = "true" WHERE C_ID = 10;
UPDATE `aRMS`.`T_ARMS_REQSTATE` SET C_CHECK = "true" WHERE C_ID = 11;
UPDATE `aRMS`.`T_ARMS_REQSTATE` SET C_CHECK = "true" WHERE C_ID = 12;
UPDATE `aRMS`.`T_ARMS_REQSTATE` SET C_CHECK = "false" WHERE C_ID = 20;
UPDATE `aRMS`.`T_ARMS_REQSTATE` SET C_CHECK = "false" WHERE C_ID = 27;

--
-- Table structure for table `T_ARMS_JIRAISSUESTATUS_CATEGORY_MAP`
--
CREATE TABLE IF NOT EXISTS `aRMS`.`T_ARMS_JIRAISSUESTATUS_CATEGORY_MAP_LOG` (

    `c_id`                                   bigint(20) NOT NULL COMMENT '노드 아이디',
    `c_parentid`                             bigint(20) NOT NULL COMMENT '부모 노드 아이디',
    `c_position`                             bigint(20) NOT NULL COMMENT '노드 포지션',
    `c_left`                                 bigint(20) NOT NULL COMMENT '노드 좌측 끝 포인트',
    `c_right`                                bigint(20) NOT NULL COMMENT '노드 우측 끝 포인트',
    `c_level`                                bigint(20) NOT NULL COMMENT '노드 DEPTH',
    `c_title`                                VARCHAR(255) COMMENT '노드 명',
    `c_type`                                 VARCHAR(255) COMMENT '노드 타입',

    `c_method`                               text NULL COMMENT '노드 변경 행위',
    `c_state`                                text NULL COMMENT '노드 상태값 ( 이전인지. 이후인지)',
    `c_date`                                 DATETIME NULL COMMENT '노드 변경 시',

    `c_req_state_mapping_id`                 bigint null comment '암스 상태 매핑 아이디',

    `c_check`                                text NULL,
    `c_contents`                             longtext NULL,
    `c_desc`                                 text NULL,
    `c_etc`                                  text NULL

) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='지라 이슈 상태 카테고리 매핑 트리거 로그';


CREATE TABLE IF NOT EXISTS `aRMS`.`T_ARMS_JIRAISSUESTATUS_CATEGORY_MAP` (

    `c_id`                                   bigint(20) AUTO_INCREMENT primary key COMMENT '노드 아이디',
    `c_parentid`                             bigint(20) NOT NULL COMMENT '부모 노드 아이디',
    `c_position`                             bigint(20) NOT NULL COMMENT '노드 포지션',
    `c_left`                                 bigint(20) NOT NULL COMMENT '노드 좌측 끝 포인트',
    `c_right`                                bigint(20) NOT NULL COMMENT '노드 우측 끝 포인트',
    `c_level`                                bigint(20) NOT NULL COMMENT '노드 DEPTH',
    `c_title`                                VARCHAR(255) COMMENT '노드 명',
    `c_type`                                 VARCHAR(255) COMMENT '노드 타입',

    `c_req_state_mapping_id`                 bigint null comment '암스 상태 매핑 아이디',

    `c_check`                                text NULL,
    `c_contents`                             longtext NULL,
    `c_desc`                                 text NULL,
    `c_etc`                                  text NULL

) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='지라 이슈 상태 카테고리 매핑';


DELIMITER $$
CREATE TRIGGER TG_INSERT_T_ARMS_JIRAISSUESTATUS_CATEGORY_MAP
    BEFORE  INSERT ON T_ARMS_JIRAISSUESTATUS_CATEGORY_MAP
    FOR EACH ROW
BEGIN
    insert into T_ARMS_JIRAISSUESTATUS_CATEGORY_MAP_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (NEW.C_ID,NEW.C_PARENTID,NEW.C_POSITION,NEW.C_LEFT,NEW.C_RIGHT,NEW.C_LEVEL,NEW.C_TITLE,NEW.C_TYPE,'update','변경이전데이터',now());
END $$
DELIMITER ;

DELIMITER $$
CREATE TRIGGER TG_UPDATE_T_ARMS_JIRAISSUESTATUS_CATEGORY_MAP
    BEFORE  UPDATE ON T_ARMS_JIRAISSUESTATUS_CATEGORY_MAP
    FOR EACH ROW
BEGIN
    insert into T_ARMS_JIRAISSUESTATUS_CATEGORY_MAP_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (OLD.C_ID,OLD.C_PARENTID,OLD.C_POSITION,OLD.C_LEFT,OLD.C_RIGHT,OLD.C_LEVEL,OLD.C_TITLE,OLD.C_TYPE,'update','변경이전데이터',now());
    insert into T_ARMS_JIRAISSUESTATUS_CATEGORY_MAP_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (NEW.C_ID,NEW.C_PARENTID,NEW.C_POSITION,NEW.C_LEFT,NEW.C_RIGHT,NEW.C_LEVEL,NEW.C_TITLE,NEW.C_TYPE,'update','변경이후데이터',now());
END $$
DELIMITER ;

DELIMITER $$
CREATE TRIGGER TG_DELETE_T_ARMS_JIRAISSUESTATUS_CATEGORY_MAP
    BEFORE  DELETE ON T_ARMS_JIRAISSUESTATUS_CATEGORY_MAP
    FOR EACH ROW
BEGIN
    insert into T_ARMS_JIRAISSUESTATUS_CATEGORY_MAP_LOG (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_METHOD, C_STATE, C_DATE)
    values (OLD.C_ID,OLD.C_PARENTID,OLD.C_POSITION,OLD.C_LEFT,OLD.C_RIGHT,OLD.C_LEVEL,OLD.C_TITLE,OLD.C_TYPE,'delete','삭제된데이터',now());
END $$
DELIMITER ;

INSERT INTO `aRMS`.`T_ARMS_JIRAISSUESTATUS_CATEGORY_MAP` (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE)
VALUES (1, 0, 0, 1, 18, 0, 'T_ARMS_JIRAISSUESTATUS_CATEGORY_MAP', 'root');
INSERT INTO `aRMS`.`T_ARMS_JIRAISSUESTATUS_CATEGORY_MAP` (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE)
VALUES (2, 1, 0, 2, 17, 1, '지라 이슈 상태 카테고리 매핑', 'drive');
INSERT INTO `aRMS`.`T_ARMS_JIRAISSUESTATUS_CATEGORY_MAP` (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_REQ_STATE_MAPPING_ID)
VALUES (3, 2, 0, 3, 4, 2, 'new', 'default', 10);
INSERT INTO `aRMS`.`T_ARMS_JIRAISSUESTATUS_CATEGORY_MAP` (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_REQ_STATE_MAPPING_ID)
VALUES (4, 2, 1, 5, 6, 2, 'indeterminate', 'default', 11);
INSERT INTO `aRMS`.`T_ARMS_JIRAISSUESTATUS_CATEGORY_MAP` (C_ID, C_PARENTID, C_POSITION, C_LEFT, C_RIGHT, C_LEVEL, C_TITLE, C_TYPE, C_REQ_STATE_MAPPING_ID)
VALUES (5, 2, 2, 7, 8, 2, 'done', 'default', 12);