import CLASS from './class'
import { Chart } from './core'

Chart.prototype.focus = function(targetIds) {
  var $$ = this.internal,
    candidates

  targetIds = $$.mapToTargetIds(targetIds)
  ;(candidates = $$.svg.selectAll(
    $$.selectorTargets(targetIds.filter($$.isTargetToShow, $$))
  )),
    this.revert()
  this.defocus()
  candidates.classed(CLASS.focused, true).classed(CLASS.defocused, false)
  if ($$.hasArcType()) {
    $$.expandArc(targetIds)
  }
  $$.toggleFocusLegend(targetIds, true)

  $$.focusedTargetIds = targetIds
  $$.defocusedTargetIds = $$.defocusedTargetIds.filter(function(id) {
    return targetIds.indexOf(id) < 0
  })
}

Chart.prototype.defocus = function(targetIds) {
  var $$ = this.internal,
    candidates

  targetIds = $$.mapToTargetIds(targetIds)
  ;(candidates = $$.svg.selectAll(
    $$.selectorTargets(targetIds.filter($$.isTargetToShow, $$))
  )),
    candidates.classed(CLASS.focused, false).classed(CLASS.defocused, true)
  if ($$.hasArcType()) {
    $$.unexpandArc(targetIds)
  }
  $$.toggleFocusLegend(targetIds, false)

  $$.focusedTargetIds = $$.focusedTargetIds.filter(function(id) {
    return targetIds.indexOf(id) < 0
  })
  $$.defocusedTargetIds = targetIds
}

Chart.prototype.revert = function(targetIds) {
  var $$ = this.internal,
    candidates

  targetIds = $$.mapToTargetIds(targetIds)
  candidates = $$.svg.selectAll($$.selectorTargets(targetIds)) // should be for all targets

  candidates.classed(CLASS.focused, false).classed(CLASS.defocused, false)
  if ($$.hasArcType()) {
    $$.unexpandArc(targetIds)
  }
  if ($$.config.legend_show) {
    $$.showLegend(targetIds.filter($$.isLegendToShow.bind($$)))
    $$.legend
      .selectAll($$.selectorLegends(targetIds))
      .filter(function() {
        return $$.d3.select(this).classed(CLASS.legendItemFocused)
      })
      .classed(CLASS.legendItemFocused, false)
  }

  $$.focusedTargetIds = []
  $$.defocusedTargetIds = []
}
