/**
 * Copyright (c) 2020-2025, JGraph Holdings Ltd
 * Copyright (c) 2020-2025, draw.io AG
 */
(function()
{
	// Adds Cisco Safe stencils
	Sidebar.prototype.addCiscoSafePalette = function()
	{
		this.setCurrentSearchEntryLibrary('cisco_safe', 'cisco_safeArchitecture');
		this.addCiscoSafeArchitecturePalette();
		this.setCurrentSearchEntryLibrary('cisco_safe', 'cisco_safeBusiness Icons');
		this.addCiscoSafeBusinessIconsPalette();
		this.setCurrentSearchEntryLibrary('cisco_safe', 'cisco_safeCapability');
		this.addCiscoSafeCapabilityPalette();
		this.setCurrentSearchEntryLibrary('cisco_safe', 'cisco_safeDesign');
		this.addCiscoSafeDesignPalette();
		this.setCurrentSearchEntryLibrary('cisco_safe', 'cisco_safeIoT Things Icons');
		this.addCiscoSafeIoTThingsIconsPalette();
		this.setCurrentSearchEntryLibrary('cisco_safe', 'cisco_safePeople Places Things Icons');
		this.addCiscoSafePeoplePlacesThingsIconsPalette();
		this.setCurrentSearchEntryLibrary('cisco_safe', 'cisco_safeSecurity Icons');
		this.addCiscoSafeSecurityIconsPalette();
		this.setCurrentSearchEntryLibrary('cisco_safe', 'cisco_safeTechnology Icons');
		this.addCiscoSafeTechnologyIconsPalette();
		this.setCurrentSearchEntryLibrary('cisco_safe', 'cisco_safeThreat');
		this.addCiscoSafeThreatPalette();
		this.setCurrentSearchEntryLibrary();
	};
	
	Sidebar.prototype.addCiscoSafeArchitecturePalette = function()
	{
		var s = mxConstants.STYLE_VERTICAL_LABEL_POSITION + '=bottom;sketch=0;html=1;fillColor=#6ABD46;strokeColor=#ffffff;' + mxConstants.STYLE_VERTICAL_ALIGN + '=top;align=center;' + 
	 	'points=[[0.085,0.085,0],[0.915,0.085,0],[0.915,0.915,0],[0.085,0.915,0],[0.25,0,0],[0.5,0,0],[0.75,0,0],[1,0.25,0],[1,0.5,0],[1,0.75,0],[0.75,1,0],[0.5,1,0],[0.25,1,0],[0,0.75,0],[0,0.5,0],[0,0.25,0]];pointerEvents=1;' + mxConstants.STYLE_SHAPE + "=mxgraph.cisco_safe.";
		var gn = 'mxgraph.cisco_safe.architecture';
		var dt = 'cisco safe architecture';

		var w = 50;

		this.addPaletteFunctions('cisco_safeArchitecture', 'Cisco Safe / Architecture', false,
		[
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.switch;',
					 w, w, '', 'Access Switch', null, null, this.getTagsForStencil(gn, 'access switch', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.aci_controller;',
					 w, w, '', 'ACI Controller', null, null, this.getTagsForStencil(gn, 'aci controller', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.aci_leaf_switch;',
					 w, w, '', 'ACI Leaf Switch', null, null, this.getTagsForStencil(gn, 'aci leaf switch', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.aci_spine_switch;',
					 w, w, '', 'ACI Spine Switch', null, null, this.getTagsForStencil(gn, 'aci spine switch', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.actuator;',
					 w, w, '', 'Actuator', null, null, this.getTagsForStencil(gn, 'actuator', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.adaptive_security_appliance;',
					 w, w, '', 'Adaptive Security Appliance', null, null, this.getTagsForStencil(gn, 'adaptive security appliance', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.automated_system;',
					 w, w, '', 'Automated System', null, null, this.getTagsForStencil(gn, 'automated system', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.blade_server;',
					 w, w, '', 'Blade Server', null, null, this.getTagsForStencil(gn, 'blade server', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.catalyst_switch;',
					 w, w, '', 'Catalyst Switch', null, null, this.getTagsForStencil(gn, 'catalyst switch', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.cisco_appliance;',
					 w, w, '', 'Cisco Appliance', null, null, this.getTagsForStencil(gn, 'cisco appliance', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.l3_switch;',
					 w, w, '', 'Core Switch', null, null, this.getTagsForStencil(gn, 'core switch', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.corporate_device1;',
					 w, w, '', 'Corporate Device', null, null, this.getTagsForStencil(gn, 'corporate device', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.corporate_device;',
					 w, w, '', 'Corporate Wireless Device', null, null, this.getTagsForStencil(gn, 'corporate wireless device', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.ddos_protection_appliance;',
					 w, w, '', 'DDOS Protection Appliance', null, null, this.getTagsForStencil(gn, 'ddos protection appliance', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.stacked_switch;',
					 w, w, '', 'Distribution Switch', null, null, this.getTagsForStencil(gn, 'distribution switch', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.email_security;',
					 w, w, '', 'Email Security', null, null, this.getTagsForStencil(gn, 'email security', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.endpoint_concentrator;',
					 w, w, '', 'Endpoint Concentrator', null, null, this.getTagsForStencil(gn, 'endpoint concentrator', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.fabric_switch;',
					 w, w, '', 'Fabric Switch', null, null, this.getTagsForStencil(gn, 'fabric switch', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.firepower_appliance;',
					 w, w, '', 'Firepower Appliance', null, null, this.getTagsForStencil(gn, 'firepower appliance', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.firepower_management_center;',
					 w, w, '', 'Firepower Management Center', null, null, this.getTagsForStencil(gn, 'firepower management center', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.firewall;',
					 w, w, '', 'Firewall', null, null, this.getTagsForStencil(gn, 'firewall', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.flow_collector;',
					 w, w, '', 'Flow Collector', null, null, this.getTagsForStencil(gn, 'flow collector', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.flow_sensor;',
					 w, w, '', 'Flow Sensor', null, null, this.getTagsForStencil(gn, 'flow sensor', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.generic_appliance;',
					 w, w, '', 'Generic Appliance', null, null, this.getTagsForStencil(gn, 'generic appliance', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.identity_directory;',
					 w, w, '', 'Identity Directory', null, null, this.getTagsForStencil(gn, 'identity directory', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.intrusion_detection;',
					 w, w, '', 'Intrusion Detection', null, null, this.getTagsForStencil(gn, 'intrusion detection', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.intrusion_detection;',
					 w, w, '', 'Intrusion Prevention', null, null, this.getTagsForStencil(gn, 'intrusion prevention', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.l3_switch;',
					 w, w, '', 'L3 Switch', null, null, this.getTagsForStencil(gn, 'l3 switch', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.aci_leaf_switch;',
					 w, w, '', 'Leaf Switch', null, null, this.getTagsForStencil(gn, 'leaf switch', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.load_balancer;',
					 w, w, '', 'Load Balancer', null, null, this.getTagsForStencil(gn, 'load balancer', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.log_collector;',
					 w, w, '', 'Log Collector', null, null, this.getTagsForStencil(gn, 'log collector', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.mgmt_console;',
					 w, w, '', 'Management Console', null, null, this.getTagsForStencil(gn, 'mgmt management console', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.mdm;',
					 w, w, '', 'MDM', null, null, this.getTagsForStencil(gn, 'mdm', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.mobile;',
					 w, w, '', 'Mobile', null, null, this.getTagsForStencil(gn, 'mobile', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.monitoring;',
					 w, w, '', 'Monitoring', null, null, this.getTagsForStencil(gn, 'monitoring', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.nexus_1kv;',
					 w, w, '', 'Nexus 1kv', null, null, this.getTagsForStencil(gn, 'nexus 1kv', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.nexus_data_center_switch;',
					 w, w, '', 'Nexus Data Center Switch', null, null, this.getTagsForStencil(gn, 'nexus data center switch', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.nexus_fabric_switch;',
					 w, w, '', 'Nexus Fabric Switch', null, null, this.getTagsForStencil(gn, 'nexus fabric switch', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.nexus_switch;',
					 w, w, '', 'Nexus Switch', null, null, this.getTagsForStencil(gn, 'nexus switch', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.ntp;',
					 w, w, '', 'NTP', null, null, this.getTagsForStencil(gn, 'ntp', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.phone;',
					 w, w, '', 'Phone', null, null, this.getTagsForStencil(gn, 'phone', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.policy;',
					 w, w, '', 'Policy', null, null, this.getTagsForStencil(gn, 'policy', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.radware_appliance;',
					 w, w, '', 'Radware Appliance', null, null, this.getTagsForStencil(gn, 'radware appliance', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.router;',
					 w, w, '', 'Router', null, null, this.getTagsForStencil(gn, 'router', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.sandbox_appliance;',
					 w, w, '', 'Sandbox Appliance', null, null, this.getTagsForStencil(gn, 'sandbox appliance', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.aci_controller;',
					 w, w, '', 'SD Controller', null, null, this.getTagsForStencil(gn, 'sd controller', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.sd_wan;',
					 w, w, '', 'SD WAN', null, null, this.getTagsForStencil(gn, 'sd wan wireless area network', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.sd_wan_2;',
					 w, w, '', 'SD WAN', null, null, this.getTagsForStencil(gn, 'sd wan wireless area network', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.secure_dns;',
					 w, w, '', 'Secure DNS', null, null, this.getTagsForStencil(gn, 'secure dns domain name server', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.secure_server;',
					 w, w, '', 'Secure Server', null, null, this.getTagsForStencil(gn, 'secure server', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.sensor;',
					 w, w, '', 'Sensor', null, null, this.getTagsForStencil(gn, 'sensor', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.server;',
					 w, w, '', 'Server', null, null, this.getTagsForStencil(gn, 'server', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.siem;',
					 w, w, '', 'SIEM', null, null, this.getTagsForStencil(gn, 'siem', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.aci_spine_switch;',
					 w, w, '', 'Spine Switch', null, null, this.getTagsForStencil(gn, 'spine switch', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.stacked_switch;',
					 w, w, '', 'Stacked Switch', null, null, this.getTagsForStencil(gn, 'stacked switch', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.storage;',
					 w, w, '', 'Storage', null, null, this.getTagsForStencil(gn, 'storage', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.switch;',
					 w, w, '', 'Switch', null, null, this.getTagsForStencil(gn, 'switch', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.tetration_analytics;',
					 w, w, '', 'Tetration Analytics', null, null, this.getTagsForStencil(gn, 'tetration analytics', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.tls_appliance;',
					 w, w, '', 'TLS Appliance', null, null, this.getTagsForStencil(gn, 'tls appliance', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.unified_access_switch;',
					 w, w, '', 'Unified Access Switch', null, null, this.getTagsForStencil(gn, 'unified access switch', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.udp_director;',
					 w, w, '', 'UDP Director', null, null, this.getTagsForStencil(gn, 'udp director', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.video_endpoint;',
					 w, w, '', 'Video Endpoint', null, null, this.getTagsForStencil(gn, 'video endpoint', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.vpn_concentrator;',
					 w, w, '', 'VPN Concentrator', null, null, this.getTagsForStencil(gn, 'vpn virtual private network concentrator', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.vulnerability_management;',
					 w, w, '', 'Vulnerability Management', null, null, this.getTagsForStencil(gn, 'vulnerability management', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.web_application_firewall;',
					 w, w, '', 'Web Application Firewall', null, null, this.getTagsForStencil(gn, 'web application firewall', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.web_application_firewall_2;',
					 w, w, '', 'Web Application Firewall', null, null, this.getTagsForStencil(gn, 'web application firewall', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.web_filtering;',
					 w, w, '', 'Web Filtering', null, null, this.getTagsForStencil(gn, 'web filtering', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.web_security;',
					 w, w, '', 'Web Security', null, null, this.getTagsForStencil(gn, 'web security', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.wide_area_application_engine;',
					 w, w, '', 'Wide Area Application Engine', null, null, this.getTagsForStencil(gn, 'wide area application engine', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.wireless_access_point;',
					 w, w, '', 'Wireless Access Point', null, null, this.getTagsForStencil(gn, 'wireless access point', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'compositeIcon;bgIcon=' + gn + '.generic_appliance;resIcon=' + gn + '.wireless_lan_controller;',
					 w, w, '', 'Wireless LAN Controller', null, null, this.getTagsForStencil(gn, 'wireless lan controller', dt).join(' '))
		]);
	};
	
	Sidebar.prototype.addCiscoSafeBusinessIconsPalette = function()
	{
		var w = 50;
		var h = 50;
		var s = mxConstants.STYLE_VERTICAL_LABEL_POSITION + '=bottom;sketch=0;html=1;fillColor=#282828;strokeColor=none;' + mxConstants.STYLE_VERTICAL_ALIGN + '=top;pointerEvents=1;align=center;shape=mxgraph.cisco_safe.business_icons.';
		var gn = 'mxgraph.cisco_safe.business_icons';
		var dt = 'cisco safe business';

		this.addPaletteFunctions('cisco_safeBusiness Icons', 'Cisco Safe / Business Icons', false,
		[
	   		 this.createVertexTemplateEntry(s + 'icon1;',
					 w, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon2;',
					 w, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon3;',
					 w * 0.9, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon4;',
					 w, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon5;',
					 w, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon6;',
					 w, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon7;',
					 w, h * 0.7, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon8;',
					 w * 0.77, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon9;',
					 w * 0.81, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon10;',
					 w, h * 0.88, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon11;',
					 w, h * 0.84, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon12;',
					 w, h * 0.89, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon13;',
					 w, h * 0.56, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon14;',
					 w, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon15;',
					 w * 0.76, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon16;',
					 w, h * 0.75, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon17;',
					 w, h * 0.69, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon18;',
					 w * 0.82, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon19;',
					 w, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon20;',
					 w * 0.89, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon21;',
					 w * 0.99, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon22;',
					 w * 0.93, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon23;',
					 w * 0.87, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon24;',
					 w, h * 0.62, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon25;',
					 w, h * 0.81, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon26;',
					 w, h * 0.71, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon27;',
					 w, h * 0.99, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon28;',
					 w * 0.94, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon29;',
					 w, h * 0.84, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon30;',
					 w, h * 0.97, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' '))
		]);
	};
	
	Sidebar.prototype.addCiscoSafeCapabilityPalette = function()
	{
		var ptss = 'points=[[0.145,0.145,0],[0.5,0,0],[0.855,0.145,0],[1,0.5,0],[0.855,0.855,0],[0.5,1,0],[0.145,0.855,0],[0,0.5,0]];';
		var n2 = mxConstants.STYLE_VERTICAL_LABEL_POSITION + '=bottom;sketch=0;html=1;strokeColor=#ffffff;' + mxConstants.STYLE_VERTICAL_ALIGN + '=top;align=center;' + 
			ptss + 'pointerEvents=1;' + mxConstants.STYLE_SHAPE + "=mxgraph.cisco_safe.";
		var n3 = 'fillColor=#6ABD46;' + n2;
		var n4 = 'fillColor=#999999;' + n2;
		var n2 = 'fillColor=#28A8E0;' + n2;
		var gn = 'mxgraph.cisco_safe.capability';
		var dt = 'cisco safe capability';

		var w = 43;
		
		this.addPaletteFunctions('cisco_safeCapability', 'Cisco Safe / Capability', false,
		[
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.access_control_using_trustsec;',
					 w, w, '', 'Access Control Using TrustSec', null, null, this.getTagsForStencil(gn, 'access control using trustsec', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.analysis_correlation;',
					 w, w, '', 'Analysis Correlation', null, null, this.getTagsForStencil(gn, 'analysis correlation', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.anomaly_detection;',
					 w, w, '', 'Anomaly Detection', null, null, this.getTagsForStencil(gn, 'anomaly detection', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.anti_malware;',
					 w, w, '', 'Anti-Malware', null, null, this.getTagsForStencil(gn, 'anti malware', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.anti_spam;',
					 w, w, '', 'Anti-Spam', null, null, this.getTagsForStencil(gn, 'anti spam', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.anti_virus;',
					 w, w, '', 'Anti-Virus', null, null, this.getTagsForStencil(gn, 'anti virus', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.application;',
					 w, w, '', 'Application', null, null, this.getTagsForStencil(gn, 'application', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.application_visibility_control;',
					 w, w, '', 'Application Visibility Control', null, null, this.getTagsForStencil(gn, 'application visibility control', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.casb;',
					 w, w, '', 'CASB', null, null, this.getTagsForStencil(gn, 'casb', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.client_based_security;',
					 w, w, '', 'Client-Based Security', null, null, this.getTagsForStencil(gn, 'client based security', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n3 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.block;',
					 w, w, '', 'Block', null, null, this.getTagsForStencil(gn, 'block', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.cloud_web_security;',
					 w, w, '', 'Cloud Web Security', null, null, this.getTagsForStencil(gn, 'cloud web security', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.conference_bridge;',
					 w, w, '', 'Conference Bridge', null, null, this.getTagsForStencil(gn, 'conference bridge', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.database;',
					 w, w, '', 'Database', null, null, this.getTagsForStencil(gn, 'database', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.data_loss_prevention;',
					 w, w, '', 'Data Loss Prevention', null, null, this.getTagsForStencil(gn, 'data loss prevention', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.device_profiling;',
					 w, w, '', 'Device Profiling', null, null, this.getTagsForStencil(gn, 'device profiling', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.device_trajectory;',
					 w, w, '', 'Device Trajectory', null, null, this.getTagsForStencil(gn, 'device trajectory', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.disk_encryption;',
					 w, w, '', 'Disk Encryption', null, null, this.getTagsForStencil(gn, 'disk encryption', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.distributed_denial_of_service_protection;',
					 w, w, '', 'Distributed Denial of Service Protection', null, null, this.getTagsForStencil(gn, 'distributed denial of service protection', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.dns;',
					 w, w, '', 'DNS', null, null, this.getTagsForStencil(gn, 'dns', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.dns_security;',
					 w, w, '', 'DNS Security', null, null, this.getTagsForStencil(gn, 'dns security', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.email_encryption;',
					 w, w, '', 'Email Encryption', null, null, this.getTagsForStencil(gn, 'email encryption', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.email_security;',
					 w, w, '', 'Email Security', null, null, this.getTagsForStencil(gn, 'email security', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.file_trajectory;',
					 w, w, '', 'File Trajectory', null, null, this.getTagsForStencil(gn, 'file trajectory', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.fabric_switching;',
					 w, w, '', 'Fabric Switching', null, null, this.getTagsForStencil(gn, 'fabric switching', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.firewall;',
					 w, w, '', 'Firewall', null, null, this.getTagsForStencil(gn, 'firewall', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.flow_analytics;',
					 w, w, '', 'Flow Analytics', null, null, this.getTagsForStencil(gn, 'flow analytics', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.identity_authorization;',
					 w, w, '', 'Identity Authorization', null, null, this.getTagsForStencil(gn, 'identity authorization', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.identity_authorization_alt;',
					 w, w, '', 'Identity Authorization (alternative)', null, null, this.getTagsForStencil(gn, 'identity authorization alt alternative', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.intrusion_detection;',
					 w, w, '', 'Intrusion Detection', null, null, this.getTagsForStencil(gn, 'intrusion detection', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.intrusion_prevention;',
					 w, w, '', 'Intrusion Prevention', null, null, this.getTagsForStencil(gn, 'intrusion prevention', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.l2_l3_network;',
					 w, w, '', 'L2 L3 Network', null, null, this.getTagsForStencil(gn, 'l2 l3 network', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.l2_l3_network_virtual;',
					 w, w, '', 'L2 L3 Network (virtual)', null, null, this.getTagsForStencil(gn, 'l2 l3 network virtual', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.l2_switching;',
					 w, w, '', 'L2 Switching', null, null, this.getTagsForStencil(gn, 'l2 switching', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.l3_switching;',
					 w, w, '', 'L3 Switching', null, null, this.getTagsForStencil(gn, 'l3 switching', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.load_balancer;',
					 w, w, '', 'Load Balancer', null, null, this.getTagsForStencil(gn, 'load balancer', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.logging_reporting;',
					 w, w, '', 'Logging Reporting', null, null, this.getTagsForStencil(gn, 'logging reporting', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.malware_sandbox;',
					 w, w, '', 'Malware Sandbox', null, null, this.getTagsForStencil(gn, 'malware sandbox', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.micro_segmentation;',
					 w, w, '', 'Micro-Segmentation', null, null, this.getTagsForStencil(gn, 'micro segmentation', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.mobile_device_manager;',
					 w, w, '', 'Mobile Device Manager', null, null, this.getTagsForStencil(gn, 'mobile device manager', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.multi_factor_identification;',
					 w, w, '', 'Multi-Factor Identification', null, null, this.getTagsForStencil(gn, 'multi factor identification', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.monitoring;',
					 w, w, '', 'Monitoring', null, null, this.getTagsForStencil(gn, 'monitoring', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.policy_configuration;',
					 w, w, '', 'Policy Configuration', null, null, this.getTagsForStencil(gn, 'policy configuration', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.posture_assessment;',
					 w, w, '', 'Posture Assessment', null, null, this.getTagsForStencil(gn, 'posture assessment', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n3 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.quarantine;',
					 w, w, '', 'Quarantine', null, null, this.getTagsForStencil(gn, 'quarantine', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n3 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.remediate;',
					 w, w, '', 'Remediate', null, null, this.getTagsForStencil(gn, 'remediate', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.routing;',
					 w, w, '', 'Routing', null, null, this.getTagsForStencil(gn, 'routing', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.server_based_security;',
					 w, w, '', 'Server Based Security', null, null, this.getTagsForStencil(gn, 'server based security', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.tagging;',
					 w, w, '', 'Tagging', null, null, this.getTagsForStencil(gn, 'tagging', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.ssl_tls_offload;',
					 w, w, '', 'SSL TLS Offload', null, null, this.getTagsForStencil(gn, 'ssl tls offload', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.storage;',
					 w, w, '', 'Storage', null, null, this.getTagsForStencil(gn, 'storage', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.threat_intelligence;',
					 w, w, '', 'Threat Intelligence', null, null, this.getTagsForStencil(gn, 'threat intelligence', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.time_synchronization;',
					 w, w, '', 'Time Synchronization', null, null, this.getTagsForStencil(gn, 'time synchronization', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.user;',
					 w, w, '', 'User', null, null, this.getTagsForStencil(gn, 'user', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.video;',
					 w, w, '', 'Video', null, null, this.getTagsForStencil(gn, 'video', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.virtualized_capability;',
					 w, w, '', 'Virtualized Capability', null, null, this.getTagsForStencil(gn, 'virtualized capability', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.virtual_firewall;',
					 w, w, '', 'Virtual Firewall', null, null, this.getTagsForStencil(gn, 'virtual firewall', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.virtual_l2_switching;',
					 w, w, '', 'Virtual L2 Switching', null, null, this.getTagsForStencil(gn, 'virtual l2 switching', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.virtual_private_network;',
					 w, w, '', 'Virtual Private Network', null, null, this.getTagsForStencil(gn, 'virtual private network vpn', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.voice;',
					 w, w, '', 'Voice', null, null, this.getTagsForStencil(gn, 'voice', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.vpn_concentrator;',
					 w, w, '', 'VPN Concentrator', null, null, this.getTagsForStencil(gn, 'vpn concentrator virtual private network', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.vulnerability_management;',
					 w, w, '', 'Vulnerability Management', null, null, this.getTagsForStencil(gn, 'vulnerability management', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.web_application_firewall;',
					 w, w, '', 'Web Application Firewall', null, null, this.getTagsForStencil(gn, 'web application firewall', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.web_reputation_filtering_dcs;',
					 w, w, '', 'Web Reputation Filtering DCS', null, null, this.getTagsForStencil(gn, 'web reputation filtering dcs', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.web_security;',
					 w, w, '', 'Web Security', null, null, this.getTagsForStencil(gn, 'web security', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.wireless_connection;',
					 w, w, '', 'Wireless Connection', null, null, this.getTagsForStencil(gn, 'wireless connection', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.wireless_intrusion_detection_system;',
					 w, w, '', 'Wireless Intrusion Detection System', null, null, this.getTagsForStencil(gn, 'wireless intrusion detection system', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.wireless_intrusion_prevention_system;',
					 w, w, '', 'Wireless Intrusion Prevention System', null, null, this.getTagsForStencil(gn, 'wireless intrusion prevention system', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.wireless_rogue_detection;',
					 w, w, '', 'Wireless Rogue Detection', null, null, this.getTagsForStencil(gn, 'wireless rogue detection', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n4 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.routing;',
					 w, w, '', 'Routing', null, null, this.getTagsForStencil(gn, 'routing', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n4 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.l2_switching;',
					 w, w, '', 'L2 Switching', null, null, this.getTagsForStencil(gn, 'l2 switching', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n4 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.l3_switching;',
					 w, w, '', 'L3 Switching', null, null, this.getTagsForStencil(gn, 'l3 switching', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n4 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.fabric_switching;',
					 w, w, '', 'Fabric Switching', null, null, this.getTagsForStencil(gn, 'fabric switching', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n4 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.l2_l3_network;',
					 w, w, '', 'L2 L3 Network', null, null, this.getTagsForStencil(gn, 'l2 l3 network', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n4 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.wireless_connection;',
					 w, w, '', 'Wireless Connection', null, null, this.getTagsForStencil(gn, 'wireless connection', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n4 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.application_optimization;',
					 w, w, '', 'Application Optimization', null, null, this.getTagsForStencil(gn, 'application optimization', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n4 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.quality_of_service;',
					 w, w, '', 'Quality of Service', null, null, this.getTagsForStencil(gn, 'quality of service', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n4 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.path_control;',
					 w, w, '', 'Path Control', null, null, this.getTagsForStencil(gn, 'path control', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n4 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.database;',
					 w, w, '', 'Database', null, null, this.getTagsForStencil(gn, 'database', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n4 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.storage;',
					 w, w, '', 'Storage', null, null, this.getTagsForStencil(gn, 'storage', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n4 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.secure_server;',
					 w, w, '', 'Secure Server', null, null, this.getTagsForStencil(gn, 'secure server', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n4 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.voice;',
					 w, w, '', 'Voice', null, null, this.getTagsForStencil(gn, 'voice', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n4 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.video;',
					 w, w, '', 'Video', null, null, this.getTagsForStencil(gn, 'video', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n4 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.load_balancer;',
					 w, w, '', 'Load Balancer', null, null, this.getTagsForStencil(gn, 'load balancer', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n4 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.host_context;',
					 w, w, '', 'Host Context', null, null, this.getTagsForStencil(gn, 'host context', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n4 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.application;',
					 w, w, '', 'Business Application', null, null, this.getTagsForStencil(gn, 'business application', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n4 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.infrastructure_redundancy;',
					 w, w, '', 'Infrastructure Redundancy', null, null, this.getTagsForStencil(gn, 'infrastructure redundancy', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n4 + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.standardized_system_images;',
					 w, w, '', 'Standardized System Images', null, null, this.getTagsForStencil(gn, 'standardized_system_images', dt).join(' '))
		]);
	};
	
	Sidebar.prototype.addCiscoSafeDesignPalette = function()
	{
		var s = mxConstants.STYLE_VERTICAL_LABEL_POSITION + '=bottom;sketch=0;html=1;fillColor=#A153A0;' + mxConstants.STYLE_VERTICAL_ALIGN + '=top;pointerEvents=1;align=center;' + 
			'points=[[0,0.5,0],[0.125,0.25,0],[0.25,0,0],[0.5,0,0],[0.75,0,0],[0.875,0.25,0],[1,0.5,0],[0.875,0.75,0],[0.75,1,0],[0.5,1,0],[0.125,0.75,0]];shape=mxgraph.cisco_safe.design.';
		var s2 = mxConstants.STYLE_VERTICAL_LABEL_POSITION + '=bottom;sketch=0;html=1;fillColor=#A153A0;' + mxConstants.STYLE_VERTICAL_ALIGN + '=top;align=center;pointerEvents=1;shape=mxgraph.cisco_safe.design.';
		var n = mxConstants.STYLE_VERTICAL_LABEL_POSITION + '=bottom;sketch=0;html=1;fillColor=#A153A0;strokeColor=#ffffff;' + mxConstants.STYLE_VERTICAL_ALIGN + '=top;align=center;' + 
		'points=[[0,0.5,0],[0.125,0.25,0],[0.25,0,0],[0.5,0,0],[0.75,0,0],[0.875,0.25,0],[1,0.5,0],[0.875,0.75,0],[0.75,1,0],[0.5,1,0],[0.125,0.75,0]];pointerEvents=1;' + mxConstants.STYLE_SHAPE + "=mxgraph.cisco_safe.";
		var gn = 'mxgraph.cisco_safe.design';
		var dt = 'cisco safe design';

		var w = 50;

		this.addPaletteFunctions('cisco_safeDesign', 'Cisco Safe / Design', false,
		[
			this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.access_point;',
				w, w * 0.9, '', 'Access Point', null, null, this.getTagsForStencil(gn, 'access point', dt).join(' ')),
			this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.access_switch_2;',
				w, w * 0.9, '', 'Access Switch', null, null, this.getTagsForStencil(gn, 'access switch', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.aci_controller;',
	   			w, w * 0.9, '', 'ACI Controller', null, null, this.getTagsForStencil(gn, 'aci controller', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.aci_controller_2;',
	   			w, w * 0.9, '', 'ACI Controller', null, null, this.getTagsForStencil(gn, 'aci controller', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.aci_leaf_switch;',
	   			w, w * 0.9, '', 'ACI Leaf Switch', null, null, this.getTagsForStencil(gn, 'aci leaf switch', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.aci_spine_switch;',
	   			w, w * 0.9, '', 'ACI Spine Switch', null, null, this.getTagsForStencil(gn, 'aci spine switch', dt).join(' ')),
			this.createVertexTemplateEntry(s2 + 'actor_1;', 
				w * 0.47, w, '', 'Actor (female)', null, null, this.getTagsForStencil(gn, 'actor female', dt).join(' ')),
			this.createVertexTemplateEntry(s2 + 'actor_2;', 
				w * 0.38, w, '', 'Actor (male)', null, null, this.getTagsForStencil(gn, 'actuator', dt).join(' ')),
			this.createVertexTemplateEntry(s2 + 'actuator;', 
				w, w * 0.9, '', 'Actuator', null, null, this.getTagsForStencil(gn, 'actuator', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.adaptive_security_appliance;',
				w, w * 0.9, '', 'Adaptive Security Appliance', null, null, this.getTagsForStencil(gn, 'adaptive security appliance', dt).join(' ')),
			this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.adaptive_security_appliance_2;',
				w, w * 0.9, '', 'Adaptive Security Appliance', null, null, this.getTagsForStencil(gn, 'adaptive security appliance', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.automated_system;',
	   			w, w * 0.9, '', 'Automated System', null, null, this.getTagsForStencil(gn, 'automated system', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.blade_server;',
	   			w, w * 0.9, '', 'Blade Server', null, null, this.getTagsForStencil(gn, 'blade server', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.blade_server_2;',
		   		w, w * 0.9, '', 'Blade Server', null, null, this.getTagsForStencil(gn, 'blade server', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'blank_device;', 
				w, w * 0.9, '', 'Blank Device', null, null, this.getTagsForStencil(gn, 'blank device', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.blank_service;',
				w, w * 0.9, '', 'Blank Service', null, null, this.getTagsForStencil(gn, 'blank service', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.call_manager;',
				w, w * 0.9, '', 'Call Manager', null, null, this.getTagsForStencil(gn, 'call manager', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.catalyst_data_center_switch;',
				w, w * 0.9, '', 'Catalyst Data Center Switch', null, null, this.getTagsForStencil(gn, 'catalyst data center switch', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.catalyst_switch_stack;',
				w, w * 0.9, '', 'Catalyst Switch Stack', null, null, this.getTagsForStencil(gn, 'catalyst switch stack', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.cisco_amp;',
				w, w * 0.9, '', 'Cisco Amp', null, null, this.getTagsForStencil(gn, 'cisco amp amplifier', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.cisco_anyconnect;',
	   			w, w * 0.9, '', 'Cisco AnyConnect', null, null, this.getTagsForStencil(gn, 'cisco anyconnect', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.cisco_cloud_web_security;',
	   			w, w * 0.9, '', 'Cisco Cloud Web Security', null, null, this.getTagsForStencil(gn, 'cisco cloud web security', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.client_firewall;',
				w, w * 0.9, '', 'Client Firewall', null, null, this.getTagsForStencil(gn, 'client firewall', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.l3_switch;',
				w, w * 0.9, '', 'Core Switch', null, null, this.getTagsForStencil(gn, 'core switch', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.corporate_device;',
				w, w * 0.9, '', 'Corporate Device', null, null, this.getTagsForStencil(gn, 'corporate device', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.corporate_device;',
				w, w * 0.9, '', 'Corporate Wireless Device', null, null, this.getTagsForStencil(gn, 'corporate device_2', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.ddos_protection;',
				w, w * 0.9, '', 'DDOS Protection', null, null, this.getTagsForStencil(gn, 'ddos protection', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.ddos_protection_2;',
				w, w * 0.9, '', 'DDOS Protection', null, null, this.getTagsForStencil(gn, 'ddos protection', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.distribution_switch;',
	   			w, w * 0.9, '', 'Distribution Switch', null, null, this.getTagsForStencil(gn, 'distribution switch', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.email_security;',
	   			w, w * 0.9, '', 'Email Security', null, null, this.getTagsForStencil(gn, 'email security', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.encryption_offload;',
	   			w, w * 0.9, '', 'Encryption Offload', null, null, this.getTagsForStencil(gn, 'encryption offload', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.endpoint_concentrator;',
	   			w, w * 0.9, '', 'Endpoint Concentrator', null, null, this.getTagsForStencil(gn, 'endpoint concentrator', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.endpoint_concentrator_2;',
	   			w, w * 0.9, '', 'Endpoint Concentrator', null, null, this.getTagsForStencil(gn, 'endpoint concentrator', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.fabric_switch;',
	   			w, w * 0.9, '', 'Fabric Switch', null, null, this.getTagsForStencil(gn, 'fabric switch', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.firepower_appliance;',
	   			w, w * 0.9, '', 'Firepower Appliance', null, null, this.getTagsForStencil(gn, 'firepower appliance', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.firepower_appliance_2;',
	   			w, w * 0.9, '', 'Firepower Appliance', null, null, this.getTagsForStencil(gn, 'firepower appliance', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.firepower_management_center;',
	   			w, w * 0.9, '', 'Firepower Management Center', null, null, this.getTagsForStencil(gn, 'firepower management center', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.firepower_management_center_2;',
	   			w, w * 0.9, '', 'Firepower Management Center', null, null, this.getTagsForStencil(gn, 'firepower management center', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.firewall;',
	   			w, w * 0.9, '', 'Firewall', null, null, this.getTagsForStencil(gn, 'firewall', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.firewall_2;',
	   			w, w * 0.9, '', 'Firewall', null, null, this.getTagsForStencil(gn, 'firewall', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.flow_collector;',
	   			w, w * 0.9, '', 'Flow Collector', null, null, this.getTagsForStencil(gn, 'flow collector', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.flow_collector_2;',
	   			w, w * 0.9, '', 'Flow Collector', null, null, this.getTagsForStencil(gn, 'flow collector', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.flow_sensor;',
	   			w, w * 0.9, '', 'Flow Sensor', null, null, this.getTagsForStencil(gn, 'flow sensor', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.flow_sensor_2;',
	   			w, w * 0.9, '', 'Flow Sensor', null, null, this.getTagsForStencil(gn, 'flow sensor', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.intrusion_detection;',
	   			w, w * 0.9, '', 'Intrusion Prevention', null, null, this.getTagsForStencil(gn, 'intrusion detection', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.intrusion_prevention_2;',
	   			w, w * 0.9, '', 'Intrusion Prevention', null, null, this.getTagsForStencil(gn, 'intrusion detection', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.identity_directory;',
	   			w, w * 0.9, '', 'Identity Directory', null, null, this.getTagsForStencil(gn, 'identity directory', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.l2_switch;',
	   			w, w * 0.9, '', 'L2 Switch', null, null, this.getTagsForStencil(gn, 'l2 switch', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.l3_switch;',
	   			w, w * 0.9, '', 'L3 Switch', null, null, this.getTagsForStencil(gn, 'l3 switch', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.load_balancer;',
	   			w, w * 0.9, '', 'Load Balancer', null, null, this.getTagsForStencil(gn, 'load balancer', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.load_balancer_2;',
	   			w, w * 0.9, '', 'Load Balancer', null, null, this.getTagsForStencil(gn, 'load balancer', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.log_collector;',
	   			w, w * 0.9, '', 'Log collector', null, null, this.getTagsForStencil(gn, 'log collector', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.log_collector_2;',
	   			w, w * 0.9, '', 'Log collector', null, null, this.getTagsForStencil(gn, 'log collector', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.mgmt_console;',
	   			w, w * 0.9, '', 'Management Console', null, null, this.getTagsForStencil(gn, 'management console', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.mgmt_console_2;',
	   			w, w * 0.9, '', 'Management Console', null, null, this.getTagsForStencil(gn, 'management console', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.mdm;',
	   			w, w * 0.9, '', 'MDM', null, null, this.getTagsForStencil(gn, 'mdm', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.mdm_2;',
	   			w, w * 0.9, '', 'MDM', null, null, this.getTagsForStencil(gn, 'mdm', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.mobile_device;',
	   			w, w * 0.9, '', 'Mobile Device', null, null, this.getTagsForStencil(gn, 'mobile device', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.monitoring;',
	   			w, w * 0.9, '', 'Monitoring', null, null, this.getTagsForStencil(gn, 'monitoring', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.monitoring_2;',
	   			w, w * 0.9, '', 'Monitoring', null, null, this.getTagsForStencil(gn, 'monitoring', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.ms_active_directory;',
	   			w, w * 0.9, '', 'MS Active Directory', null, null, this.getTagsForStencil(gn, 'ms active directory', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.ms_active_directory_2;',
	   			w, w * 0.9, '', 'MS Active Directory', null, null, this.getTagsForStencil(gn, 'ms active directory', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.nexus_1kv;',
	   			w, w * 0.9, '', 'Nexus 1kv', null, null, this.getTagsForStencil(gn, 'nexus 1kv', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.nexus_data_center_switch;',
	   			w, w * 0.9, '', 'Nexus Data Center Switch', null, null, this.getTagsForStencil(gn, 'nexus data center switch', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.nexus_fabric_switch;',
	   			w, w * 0.9, '', 'Nexus Fabric Switch', null, null, this.getTagsForStencil(gn, 'nexus fabric switch', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.nexus_switch;',
	   			w, w * 0.9, '', 'Nexus Switch', null, null, this.getTagsForStencil(gn, 'nexus switch', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.ntp;',
	   			w, w * 0.9, '', 'NTP', null, null, this.getTagsForStencil(gn, 'ntp', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.ntp_2;',
	   			w, w * 0.9, '', 'NTP', null, null, this.getTagsForStencil(gn, 'ntp', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.phone;',
	   			w, w * 0.9, '', 'Phone', null, null, this.getTagsForStencil(gn, 'phone', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.policy;',
	   			w, w * 0.9, '', 'Policy', null, null, this.getTagsForStencil(gn, 'policy', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.policy_2;',
	   			w, w * 0.9, '', 'Policy', null, null, this.getTagsForStencil(gn, 'policy', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.radware;',
	   			w, w * 0.9, '', 'Radware Appliance', null, null, this.getTagsForStencil(gn, 'radware', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.radware_2;',
	   			w, w * 0.9, '', 'Radware Appliance', null, null, this.getTagsForStencil(gn, 'radware', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.router;',
	   			w, w * 0.9, '', 'Router', null, null, this.getTagsForStencil(gn, 'router', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.router_2;',
				w, w * 0.9, '', 'Router', null, null, this.getTagsForStencil(gn, 'router', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.sd_wan;',
	   			w, w * 0.9, '', 'SD-WAN', null, null, this.getTagsForStencil(gn, 'sd wan', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.sd_wan_2;',
	   			w, w * 0.9, '', 'SD-WAN', null, null, this.getTagsForStencil(gn, 'sd wan', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.secure_dns;',
	   			w, w * 0.9, '', 'Secure DNS', null, null, this.getTagsForStencil(gn, 'secure dns', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.secure_dns_2;',
	   			w, w * 0.9, '', 'Secure DNS', null, null, this.getTagsForStencil(gn, 'secure dns', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.sensor;',
	   			w, w * 0.9, '', 'Sensor', null, null, this.getTagsForStencil(gn, 'sensor', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.server_1;',
	   			w, w * 0.9, '', 'Server', null, null, this.getTagsForStencil(gn, 'server', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.server_3;',
	   			w, w * 0.9, '', 'Server', null, null, this.getTagsForStencil(gn, 'server', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.server_2;',
	   			w, w * 0.9, '', 'Server', null, null, this.getTagsForStencil(gn, 'server', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.server_4;',
	   			w, w * 0.9, '', 'Server', null, null, this.getTagsForStencil(gn, 'server', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.siem;',
	   			w, w * 0.9, '', 'SIEM', null, null, this.getTagsForStencil(gn, 'siem', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.siem_2;',
	   			w, w * 0.9, '', 'SIEM', null, null, this.getTagsForStencil(gn, 'siem', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.storage_1;',
	   			w, w * 0.9, '', 'Storage', null, null, this.getTagsForStencil(gn, 'storage', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.storage;',
	   			w, w * 0.9, '', 'Storage', null, null, this.getTagsForStencil(gn, 'storage', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.switch_stack;',
	   			w, w * 0.9, '', 'Switch Stack', null, null, this.getTagsForStencil(gn, 'switch stack', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.tetration_agent;',
	   			w, w * 0.9, '', 'Tetration Agent', null, null, this.getTagsForStencil(gn, 'tetration agent', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.tls_appliance;',
	   			w, w * 0.9, '', 'TLS Appliance', null, null, this.getTagsForStencil(gn, 'tls appliance', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.encryption_offload;',
	   			w, w * 0.9, '', 'TLS Appliance', null, null, this.getTagsForStencil(gn, 'tls appliance', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.udp_director;',
	   			w, w * 0.9, '', 'UDP Director', null, null, this.getTagsForStencil(gn, 'udp director', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.udp_director_2;',
	   			w, w * 0.9, '', 'UDP Director', null, null, this.getTagsForStencil(gn, 'udp director', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.user;',
	   			w, w, '', 'User', null, null, this.getTagsForStencil(gn, 'user', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.users;',
	   			w, w, '', 'Users', null, null, this.getTagsForStencil(gn, 'users', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=ellipse;resIcon=' + gn + '.video_endpoint;',
	   			w, w, '', 'Video Endpoint', null, null, this.getTagsForStencil(gn, 'video endpoint', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.virtual_secure_server;',
	   			w, w * 0.9, '', 'Virtual Secure Server', null, null, this.getTagsForStencil(gn, 'virtual secure server', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.vload_balancer;',
	   			w, w * 0.9, '', 'vLoad Balancer', null, null, this.getTagsForStencil(gn, 'vload balancer', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.vpn_concentrator;',
	   			w, w * 0.9, '', 'VPN Concentrator', null, null, this.getTagsForStencil(gn, 'vpn concentrator', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.vpn_concentrator_2;',
	   			w, w * 0.9, '', 'VPN Concentrator', null, null, this.getTagsForStencil(gn, 'vpn concentrator', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.vulnerability_management;',
	   			w, w * 0.9, '', 'Vulnerability Management', null, null, this.getTagsForStencil(gn, 'vulnerability management', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.vulnerability_management_2;',
	   			w, w * 0.9, '', 'Vulnerability Management', null, null, this.getTagsForStencil(gn, 'vulnerability management', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.vwaf_security;',
	   			w, w * 0.9, '', 'vWAF Security', null, null, this.getTagsForStencil(gn, 'vwaf security', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.vweb_security;',
	   			w, w * 0.9, '', 'vWeb Security', null, null, this.getTagsForStencil(gn, 'vweb security', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.vwlan_controller;',
	   			w, w * 0.9, '', 'vWLAN Controller', null, null, this.getTagsForStencil(gn, 'vwlan controller', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.web_application_firewall;',
	   			w, w * 0.9, '', 'Web Application Firewall', null, null, this.getTagsForStencil(gn, 'web application firewall', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.web_application_firewall_2;',
	   			w, w * 0.9, '', 'Web Application Firewall', null, null, this.getTagsForStencil(gn, 'web application firewall', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.web_filtering;',
	   			w, w * 0.9, '', 'Web Filtering', null, null, this.getTagsForStencil(gn, 'web filtering', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.web_filtering_2;',
	   			w, w * 0.9, '', 'Web Filtering', null, null, this.getTagsForStencil(gn, 'web filtering', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.web_security;',
	   			w, w * 0.9, '', 'Web Security', null, null, this.getTagsForStencil(gn, 'web security', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.wide_area_application_engine;',
	   			w, w * 0.9, '', 'Wide Area Application Engine', null, null, this.getTagsForStencil(gn, 'wide area application engine', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.wide_area_application_engine_2;',
	   			w, w * 0.9, '', 'Wide Area Application Engine', null, null, this.getTagsForStencil(gn, 'wide area application engine', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.wireless_corporate_device;',
	   			w, w * 0.9, '', 'Wireless Corporate Device', null, null, this.getTagsForStencil(gn, 'wireless corporate device', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.wireless_switch;',
	   			w, w * 0.9, '', 'Wireless Switch', null, null, this.getTagsForStencil(gn, 'wireless switch', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.wlan_controller;',
	   			w, w * 0.9, '', 'Wireless LAN Controller', null, null, this.getTagsForStencil(gn, 'wlan wireless lan controller', dt).join(' ')),
	   		this.createVertexTemplateEntry(n + 'compositeIcon;bgIcon=' + gn + '.blank_device;resIcon=' + gn + '.vwlan_controller;',
	   			w, w * 0.9, '', 'Wireless LAN Controller', null, null, this.getTagsForStencil(gn, 'wlan wireless lan controller', dt).join(' '))
		]);
	};
	
	Sidebar.prototype.addCiscoSafeIoTThingsIconsPalette = function()
	{
		var w = 50;
		var h = 50;
		var s = mxConstants.STYLE_VERTICAL_LABEL_POSITION + '=bottom;sketch=0;html=1;fillColor=#282828;strokeColor=none;' + mxConstants.STYLE_VERTICAL_ALIGN + '=top;pointerEvents=1;align=center;shape=mxgraph.cisco_safe.iot_things_icons.';
		var gn = 'mxgraph.cisco_safe.iot_things_icons';
		var dt = 'cisco safe iot things icons internet';

		var sc = 1;
		var w2 = sc * 50;

		this.addPaletteFunctions('cisco_safeIoT Things Icons', 'Cisco Safe / IoT Things Icons', false,
		[
	   		 this.createVertexTemplateEntry(s + 'icon1;',
					 w * 0.97, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon2;',
					 w, h * 0.96, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon3;',
					 w, h * 0.48, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon4;',
					 w, h * 0.78, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon5;',
					 w * 0.58, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon6;',
					 w, h * 0.99, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon7;',
					 w * 0.82, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon8;',
					 w, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon9;',
					 w, h * 0.77, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon10;',
					 w * 0.5, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon11;',
					 w, h * 0.97, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon12;',
					 w, h * 0.65, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon13;',
					 w, h * 0.56, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon14;',
					 w * 0.37, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon15;',
					 w, h * 0.65, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon16;',
					 w, h * 0.92, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon17;',
					 w * 0.7, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon18;',
					 w, h * 0.75, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon19;',
					 w, h * 0.77, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon20;',
					 w * 0.91, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon21;',
					 w, h * 0.97, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon22;',
					 w, h * 0.73, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon23;',
					 w, h * 0.9, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon24;',
					 w, h * 0.87, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon25;',
					 w, h * 0.22, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon26;',
					 w, h * 0.63, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon27;',
					 w, h * 0.5, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon28;',
					 w, h * 0.74, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon29;',
					 w, h * 0.74, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon30;',
					 w, h * 0.71, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon31;',
					 w, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon32;',
					 w, h * 0.56, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon33;',
					 w, h * 0.78, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon34;',
					 w, h * 0.7, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon35;',
					 w, h * 0.62, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon36;',
					 w * 0.53, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon37;',
					 w * 0.79, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon38;',
					 w, h * 0.91, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon39;',
					 w, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon40;',
					 w, h * 0.89, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon41;',
					 w * 0.58, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon42;',
					 w * 0.58, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon43;',
					 w * 0.96, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon44;',
					 w * 0.99, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon45;',
					 w, h * 0.99, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon46;',
					 w, h * 0.83, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon47;',
					 w, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon48;',
					 w * 0.43, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' '))
		]);
	};
	
	Sidebar.prototype.addCiscoSafePeoplePlacesThingsIconsPalette = function()
	{
		var w = 50;
		var h = 50;
		var s = mxConstants.STYLE_VERTICAL_LABEL_POSITION + '=bottom;sketch=0;html=1;fillColor=#282828;strokeColor=none;' + mxConstants.STYLE_VERTICAL_ALIGN + '=top;pointerEvents=1;align=center;shape=mxgraph.cisco_safe.people_places_things_icons.';
		var gn = 'mxgraph.cisco_safe.people_places_things_icons';
		var dt = 'cisco safe people places things';

		var sc = 1;
		var w2 = sc * 50;
		
		this.addPaletteFunctions('cisco_safePeople Places Things Icons', 'Cisco Safe / People, Places, Things Icons', false,
		[
	   		 this.createVertexTemplateEntry(s + 'icon1;',
					 w * 0.93, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon2;',
					 w, h * 0.82, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon3;',
					 w, h * 0.97, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon4;',
					 w * 0.89, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon5;',
					 w * 0.81, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon6;',
					 w, h * 0.87, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon7;',
					 w * 0.98, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon8;',
					 w * 0.39, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon9;',
					 w, h * 0.9, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon10;',
					 w, h * 0.99, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon11;',
					 w * 0.95, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' '))
		]);
	};
	
	Sidebar.prototype.addCiscoSafeSecurityIconsPalette = function()
	{
		var w = 50;
		var h = 50;
		var s = mxConstants.STYLE_VERTICAL_LABEL_POSITION + '=bottom;sketch=0;html=1;fillColor=#282828;strokeColor=none;' + mxConstants.STYLE_VERTICAL_ALIGN + '=top;pointerEvents=1;align=center;shape=mxgraph.cisco_safe.security_icons.';
		var gn = 'mxgraph.cisco_safe.security_icons';
		var dt = 'cisco safe security';

		var sc = 1;
		var w2 = sc * 50;
		
		this.addPaletteFunctions('cisco_safeSecurity Icons', 'Cisco Safe / Security Icons', false,
		[
	   		 this.createVertexTemplateEntry(s + 'ngips;',
					 w * 0.71, h * 0.85, '', 'NGIPS', null, null, this.getTagsForStencil(gn, 'ngips', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'ngfw;',
					 w * 1.05, h * 0.92, '', 'NGFW', null, null, this.getTagsForStencil(gn, 'ngfw', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'ise;',
					 w * 0.49, h * 0.69, '', 'ISE', null, null, this.getTagsForStencil(gn, 'ise', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'ids;',
					 w * 0.92, h * 0.71, '', 'IDS', null, null, this.getTagsForStencil(gn, 'ids', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'nba;',
					 w * 0.89, h * 0.67, '', 'NBA', null, null, this.getTagsForStencil(gn, 'nba', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'nac;',
					 w, h, '', 'NAC', null, null, this.getTagsForStencil(gn, 'nac', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'iam;',
					 w * 0.75, h * 0.94, '', 'IAM', null, null, this.getTagsForStencil(gn, 'iam', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'amp;',
					 w, h, '', 'AMP', null, null, this.getTagsForStencil(gn, 'amp', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'utm;',
					 w * 1.04, h * 0.23, '', 'UTM', null, null, this.getTagsForStencil(gn, 'utm', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'firewall;',
					 w * 0.99, h * 0.7, '', 'Firewall', null, null, this.getTagsForStencil(gn, 'firewall', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'vulnerability_management;',
					 w, h, '', 'Vulnerability Management', null, null, this.getTagsForStencil(gn, 'vulnerability management', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'log_management;',
					 w * 0.6, h * 0.75, '', 'Log Management', null, null, this.getTagsForStencil(gn, 'log management', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'application_control;',
					 w, h, '', 'Application Control', null, null, this.getTagsForStencil(gn, 'application control', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'virtual;',
					 w, h, '', 'Virtual', null, null, this.getTagsForStencil(gn, 'virtual', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'siem;',
					 w, h * 0.81, '', 'SIEM', null, null, this.getTagsForStencil(gn, 'siem', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'antivirus;',
					 w, h * 0.65, '', 'Antivirus', null, null, this.getTagsForStencil(gn, 'antivirus', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'patch_management;',
					 w, h * 0.78, '', 'Patch Management', null, null, this.getTagsForStencil(gn, 'patch management', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'inspection_forensics;',
					 w, h * 0.77, '', 'Inspection / Forensics', null, null, this.getTagsForStencil(gn, 'inspection forensics', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'malware_sandbox;',
					 w, h * 0.62, '', 'Malware Sandbox', null, null, this.getTagsForStencil(gn, 'malware sandbox', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'ddos;',
					 w, h, '', 'DDoS', null, null, this.getTagsForStencil(gn, 'ddos', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'talos;',
					 w * 1.86, h * 0.43, '', 'Talos', null, null, this.getTagsForStencil(gn, 'talos', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'services;',
					 w, h * 0.92, '', 'Services', null, null, this.getTagsForStencil(gn, 'services', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'vpn;',
					 w * 0.86, h, '', 'VPN', null, null, this.getTagsForStencil(gn, 'vpn', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'email;',
					 w, h * 0.71, '', 'Email', null, null, this.getTagsForStencil(gn, 'email', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'web;',
					 w, h, '', 'Web', null, null, this.getTagsForStencil(gn, 'web', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'virtual_deployment;',
					 w, h * 0.89, '', 'Virtual Deployment', null, null, this.getTagsForStencil(gn, 'virtual deployment', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'cloud_based;',
					 w, h * 0.63, '', 'Cloud Based', null, null, this.getTagsForStencil(gn, 'cloud based', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'cloud_based_management;',
					 w, h * 0.78, '', 'Cloud Based Management', null, null, this.getTagsForStencil(gn, 'cloud based management', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'trustsec;',
					 w * 0.83, h, '', 'Trustsec', null, null, this.getTagsForStencil(gn, 'trustsec', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'retrospective_security;',
					 w, h * 0.96, '', 'Retrospective Security', null, null, this.getTagsForStencil(gn, 'retrospective security', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'apic;',
					 w, h * 0.81, '', 'APIC', null, null, this.getTagsForStencil(gn, 'apic', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'waf;',
					 w * 0.8, h, '', 'WAF', null, null, this.getTagsForStencil(gn, 'waf', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon1;',
					 w * 0.95, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon2;',
					 w, h * 0.91, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon3;',
					 w * 0.78, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon4;',
					 w, h * 0.84, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon5;',
					 w * 0.82, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon6;',
					 w * 0.95, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon7;',
					 w, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon8;',
					 w * 0.85, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon9;',
					 w * 0.68, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon10;',
					 w, h * 0.62, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon11;',
					 w, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon12;',
					 w * 0.84, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon13;',
					 w, h * 0.91, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon14;',
					 w, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon15;',
					 w * 0.79, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon16;',
					 w, h * 0.47, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon17;',
					 w * 0.58, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon18;',
					 w, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon19;',
					 w, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon20;',
					 w, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon21;',
					 w * 0.87, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon22;',
					 w * 0.81, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon23;',
					 w, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon24;',
					 w * 0.89, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon25;',
					 w, h * 0.91, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon26;',
					 w, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon27;',
					 w, h * 0.7, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon28;',
					 w, h * 0.69, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon29;',
					 w * 0.92, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon30;',
					 w, h * 0.7, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon31;',
					 w, h * 0.86, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon32;',
					 w, h * 0.69, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon33;',
					 w * 0.99, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon34;',
					 w, h * 0.91, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon35;',
					 w, h * 0.57, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon36;',
					 w, h * 0.98, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon37;',
					 w * 0.81, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon38;',
					 w, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon39;',
					 w * 0.72, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon40;',
					 w, h * 0.66, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' '))
		]);
	};
	
	Sidebar.prototype.addCiscoSafeTechnologyIconsPalette = function()
	{
		var w = 50;
		var h = 50;
		var s = mxConstants.STYLE_VERTICAL_LABEL_POSITION + '=bottom;sketch=0;html=1;fillColor=#282828;strokeColor=none;' + mxConstants.STYLE_VERTICAL_ALIGN + '=top;pointerEvents=1;align=center;shape=mxgraph.cisco_safe.technology_icons.';
		var gn = 'mxgraph.cisco_safe.technology_icons';
		var dt = 'cisco safe technology';

		var sc = 1;
		var w2 = sc * 50;
		
		this.addPaletteFunctions('cisco_safeTechnology Icons', 'Cisco Safe / Technology Icons', false,
		[
	   		 this.createVertexTemplateEntry(s + 'icon1;',
					 w, h * 0.65, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon2;',
					 w * 0.58, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon3;',
					 w, h * 0.86, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon4;',
					 w, h * 0.99, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon5;',
					 w, h * 0.76, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon6;',
					 w * 0.58, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon7;',
					 w * 0.69, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon8;',
					 w * 0.91, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon9;',
					 w * 0.78, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon10;',
					 w, h * 0.82, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon11;',
					 w, h * 0.76, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon12;',
					 w * 0.79, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon13;',
					 w, h * 0.89, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon14;',
					 w, h * 0.77, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon15;',
					 w, h * 0.89, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon16;',
					 w, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon17;',
					 w, h * 0.85, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon18;',
					 w, h * 0.84, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon19;',
					 w, h * 0.84, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon20;',
					 w, h * 0.84, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon21;',
					 w * 0.86, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon22;',
					 w, h * 0.56, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon23;',
					 w, h * 0.47, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon24;',
					 w, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon25;',
					 w, h * 0.69, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon26;',
					 w, h * 0.81, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon27;',
					 w, h * 0.7, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon28;',
					 w, h * 0.43, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
	   		 this.createVertexTemplateEntry(s + 'icon29;',
					 w, h, '', '', null, null, this.getTagsForStencil(gn, '', dt).join(' '))
		]);
	};
	
	Sidebar.prototype.addCiscoSafeThreatPalette = function()
	{
		var w = 50;
		var h = 50;
		var n2 = mxConstants.STYLE_VERTICAL_LABEL_POSITION + '=bottom;sketch=0;html=1;fillColor=#F06650;strokeColor=#ffffff;' + mxConstants.STYLE_VERTICAL_ALIGN + '=top;align=center;' + 
		'points=[];pointerEvents=1;' + mxConstants.STYLE_SHAPE + "=mxgraph.cisco_safe.";
		var gn = 'mxgraph.cisco_safe.threat';
		var dt = 'cisco safe threat ';

		var sc = 1;
		var w2 = sc * 50;
		
		this.addPaletteFunctions('cisco_safeThreat', 'Cisco Safe / Threat', false,
		[
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat1;resIcon=' + gn + '.threat_a1;',
					 w2 * 0.98, w2, '', 'Threat A1', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat1;resIcon=' + gn + '.threat_a2;',
					 w2 * 0.98, w2, '', 'Threat A2', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat1;resIcon=' + gn + '.threat_a3;',
					 w2 * 0.98, w2, '', 'Threat A3', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat1;resIcon=' + gn + '.threat_a4;',
					 w2 * 0.98, w2, '', 'Threat A4', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat1;resIcon=' + gn + '.threat_a5;',
					 w2 * 0.98, w2, '', 'Threat A5', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat1;resIcon=' + gn + '.threat_a6;',
					 w2 * 0.98, w2, '', 'Threat A6', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat1;resIcon=' + gn + '.threat_a7;',
					 w2 * 0.98, w2, '', 'Threat A7', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat1;resIcon=' + gn + '.threat_a8;',
					 w2 * 0.98, w2, '', 'Threat A8', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat2;resIcon=' + gn + '.threat_b1;',
					 w2 * 0.63, w2, '', 'Threat B1', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat2;resIcon=' + gn + '.threat_b2;',
					 w2 * 0.63, w2, '', 'Threat B2', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat2;resIcon=' + gn + '.threat_b3;',
					 w2 * 0.63, w2, '', 'Threat B3', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat2;resIcon=' + gn + '.threat_b4;',
					 w2 * 0.63, w2, '', 'Threat B4', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat2;resIcon=' + gn + '.threat_b5;',
					 w2 * 0.63, w2, '', 'Threat B5', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat2;resIcon=' + gn + '.threat_b6;',
					 w2 * 0.63, w2, '', 'Threat B6', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat2;resIcon=' + gn + '.threat_b7;',
					 w2 * 0.63, w2, '', 'Threat B7', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat2;resIcon=' + gn + '.threat_b8;',
					 w2 * 0.63, w2, '', 'Threat B8', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat3;resIcon=' + gn + '.threat_c1;',
					 w2, w2 * 0.81, '', 'Threat C1', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat3;resIcon=' + gn + '.threat_c2;',
					 w2, w2 * 0.81, '', 'Threat C2', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat3;resIcon=' + gn + '.threat_c3;',
					 w2, w2 * 0.81, '', 'Threat C3', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat3;resIcon=' + gn + '.threat_c4;',
					 w2, w2 * 0.81, '', 'Threat C4', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat3;resIcon=' + gn + '.threat_c5;',
					 w2, w2 * 0.81, '', 'Threat C5', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat3;resIcon=' + gn + '.threat_c6;',
					 w2, w2 * 0.81, '', 'Threat C6', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat3;resIcon=' + gn + '.threat_c7;',
					 w2, w2 * 0.81, '', 'Threat C7', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat3;resIcon=' + gn + '.threat_c8;',
					 w2, w2 * 0.81, '', 'Threat C8', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat4;resIcon=' + gn + '.threat_d1;',
					 w2 * 0.93, w2, '', 'Threat D1', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat4;resIcon=' + gn + '.threat_d2;',
					 w2 * 0.93, w2, '', 'Threat D2', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat4;resIcon=' + gn + '.threat_d3;',
					 w2 * 0.93, w2, '', 'Threat D3', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat4;resIcon=' + gn + '.threat_d4;',
					 w2 * 0.93, w2, '', 'Threat D4', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat4;resIcon=' + gn + '.threat_d5;',
					 w2 * 0.93, w2, '', 'Threat D5', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat4;resIcon=' + gn + '.threat_d6;',
					 w2 * 0.93, w2, '', 'Threat D6', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat4;resIcon=' + gn + '.threat_d7;',
					 w2 * 0.93, w2, '', 'Threat D7', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat4;resIcon=' + gn + '.threat_d8;',
					 w2 * 0.93, w2, '', 'Threat D8', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat5;resIcon=' + gn + '.threat_e1;',
					 w2, w2 * 0.94, '', 'Threat E1', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat5;resIcon=' + gn + '.threat_e2;',
					 w2, w2 * 0.94, '', 'Threat E2', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat5;resIcon=' + gn + '.threat_e3;',
					 w2, w2 * 0.94, '', 'Threat E3', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat5;resIcon=' + gn + '.threat_e4;',
					 w2, w2 * 0.94, '', 'Threat E4', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat5;resIcon=' + gn + '.threat_e5;',
					 w2, w2 * 0.94, '', 'Threat E5', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat5;resIcon=' + gn + '.threat_e6;',
					 w2, w2 * 0.94, '', 'Threat E6', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat5;resIcon=' + gn + '.threat_e7;',
					 w2, w2 * 0.94, '', 'Threat E7', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' ')),
	   		 this.createVertexTemplateEntry(n2 + 'compositeIcon;bgIcon=threat5;resIcon=' + gn + '.threat_e8;',
					 w2, w2 * 0.94, '', 'Threat E8', null, null, this.getTagsForStencil(gn, 'threat', dt).join(' '))
		]);
	};
})();
