package com.arms.config;

import com.arms.api.bbs.model.entity.BbsEntity;
import com.arms.api.blog.model.entity.BlogEntity;
import com.arms.api.clientcase.model.ClientCaseEntity;
import com.arms.api.newsletter.model.NewsletterEntity;
import com.arms.api.poc.model.entity.PocEntity;
import com.arms.api.fluentd.entity.FluentdEntity;
import com.arms.api.holidayadmin.model.entity.HolidayEntity;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.serverinfo.model.ServerInfoEntity;
import com.arms.api.wiki.model.WikiEntity;
import com.arms.egovframework.javaservice.esframework.model.entity.IndexStatusEntity;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import com.arms.egovframework.javaservice.esframework.repository.common.FindRepository;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class EntityClassConfig {

    @Bean
    public EsCommonRepositoryWrapper<ServerInfoEntity> serverInfoEntityWrapper(FindRepository findRepository) {
        return new EsCommonRepositoryWrapper<>(findRepository, ServerInfoEntity.class);
    }

    @Bean
    public EsCommonRepositoryWrapper<AlmIssueEntity> almIssueEntityWrapper(FindRepository findRepository) {
        return new EsCommonRepositoryWrapper<>(findRepository, AlmIssueEntity.class);
    }

    @Bean
    public EsCommonRepositoryWrapper<FluentdEntity> fluentdEntityWrapper(FindRepository findRepository) {
        return new EsCommonRepositoryWrapper<>(findRepository, FluentdEntity.class);
    }

    @Bean
    public EsCommonRepositoryWrapper<BbsEntity> bbsEntityWrapper(FindRepository findRepository) {
        return new EsCommonRepositoryWrapper<>(findRepository, BbsEntity.class);
    }

    @Bean
    public EsCommonRepositoryWrapper<WikiEntity> wikiEntityWrapper(FindRepository findRepository) {
        return new EsCommonRepositoryWrapper<>(findRepository, WikiEntity.class);
    }

    @Bean
    public EsCommonRepositoryWrapper<HolidayEntity> holidayEntityWrapper(FindRepository findRepository) {
        return new EsCommonRepositoryWrapper<>(findRepository, HolidayEntity.class);
    }

    @Bean
    public EsCommonRepositoryWrapper<IndexStatusEntity> indexStatusEntityWrapper(FindRepository findRepository) {
        return new EsCommonRepositoryWrapper<>(findRepository, IndexStatusEntity.class);
    }

    @Bean
    public EsCommonRepositoryWrapper<BlogEntity> blogEntityWrapper(FindRepository findRepository) {
        return new EsCommonRepositoryWrapper<>(findRepository, BlogEntity.class);
    }

    @Bean
    public EsCommonRepositoryWrapper<PocEntity> pocEntityWrapper(FindRepository findRepository) {
        return new EsCommonRepositoryWrapper<>(findRepository, PocEntity.class);
    }

    @Bean
    public EsCommonRepositoryWrapper<NewsletterEntity>  newsletterEntityWrapper(FindRepository findRepository) {
        return new EsCommonRepositoryWrapper<>(findRepository, NewsletterEntity.class);
    }

    @Bean
    public EsCommonRepositoryWrapper<ClientCaseEntity>  clientCaseWrapper(FindRepository findRepository) {
        return new EsCommonRepositoryWrapper<>(findRepository, ClientCaseEntity.class);
    }

}
