package com.arms.api.requirement.model.vo;

import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import lombok.*;

import java.util.List;

@Builder
@Getter
@AllArgsConstructor
@NoArgsConstructor
public class HierarchicalAlmIssue {

    AlmIssueEntity almIssue;
    // 요구사항 구분
    @Setter
    private String isReqName;
    private Long linkedIssueCount; // 연결된 이슈 수
    private Long subtaskCount; // 하위이슈 수
    List<HierarchicalAlmIssue> children;

    private String pdServiceVersionNames;

    public void addIsReqName(String key) {
        this.isReqName = this.isReqName + ", \n" + key;
    }

    public static HierarchicalAlmIssue copyObject(HierarchicalAlmIssue hierarchicalAlmIssue) {
        return HierarchicalAlmIssue.builder()
                .almIssue(hierarchicalAlmIssue.getAlmIssue())
                .isReqName(hierarchicalAlmIssue.getIsReqName())
                .linkedIssueCount(hierarchicalAlmIssue.getLinkedIssueCount())
                .subtaskCount(hierarchicalAlmIssue.getSubtaskCount())
                .children(hierarchicalAlmIssue.getChildren())
                .build();
    }
}
