package com.arms.egovframework.javaservice.esframework.repository.common;

import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.factory.AggregationQueryFactory;
import com.arms.egovframework.javaservice.esframework.factory.SearchDocQueryFactory;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.MainGroupDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SearchDocDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SingleValueGroupDTO;
import com.arms.egovframework.javaservice.esframework.model.entity.BaseEntity;
import com.arms.egovframework.javaservice.esframework.model.vo.CatIndexVO;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentAggregations;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentResultWrapper;
import lombok.extern.slf4j.Slf4j;

import java.io.Serializable;
import java.util.List;

@Slf4j
public class EsCommonRepositoryWrapper<E extends BaseEntity> {

    private final FindRepository findRepository;

    private final Class<E> entityClass;

    public EsCommonRepositoryWrapper(FindRepository findRepository,Class<E> entityClass) {
        this.entityClass = entityClass;
        this.findRepository = findRepository;
    }

    private EsCommonRepository<E, Serializable> getRepository() {
        return findRepository.findRepositoryByClass(entityClass);
    }

    public DocumentAggregations aggregateRecentDocs(SimpleQuery<MainGroupDTO> simpleQuery) {
        return getRepository().aggregateRecentDocs(AggregationQueryFactory.nested(simpleQuery.toSearchDoc()).createForRecentTrue(entityClass));
    }

    public DocumentAggregations aggregateDocs(SimpleQuery<MainGroupDTO> simpleQuery) {
        return getRepository().aggregateDocs(AggregationQueryFactory.nested(simpleQuery.toSearchDoc()).create());
    }

    public DocumentAggregations aggregateDocsByDay(SimpleQuery<MainGroupDTO> simpleQuery) {
        return getRepository().aggregateDocs(AggregationQueryFactory.nestedWithDay(simpleQuery.toSearchDoc()).create());
    }

    public DocumentAggregations aggregateDocsCardinalityByDay(SimpleQuery<SingleValueGroupDTO> simpleQuery) {
        return getRepository().aggregateDocs(AggregationQueryFactory.cardinalityWithDay(simpleQuery.toSearchDoc()).create());
    }

    public DocumentAggregations aggregateRecentDocsByDay(SimpleQuery<MainGroupDTO> simpleQuery) {
        return getRepository().aggregateRecentDocs(AggregationQueryFactory.nestedWithDay(simpleQuery.toSearchDoc()).createForRecentTrue(entityClass));
    }

    public DocumentAggregations aggregateRecentDocsCardinalityByDay(SimpleQuery<SingleValueGroupDTO> simpleQuery) {
        return getRepository().aggregateRecentDocs(AggregationQueryFactory.cardinalityWithDay(simpleQuery.toSearchDoc()).createForRecentTrue(entityClass));
    }

    public DocumentAggregations aggregateRecentDocsByWeek(SimpleQuery<MainGroupDTO> simpleQuery) {
        return getRepository().aggregateRecentDocs(AggregationQueryFactory.nestedWithWeek(simpleQuery.toSearchDoc()).createForRecentTrue(entityClass));
    }

    public DocumentResultWrapper<E> findRecentHits(SimpleQuery<SearchDocDTO> simpleQuery) {
        return getRepository().findRecentHits(SearchDocQueryFactory.searchDoc(simpleQuery.toSearchDoc()).createForRecentTrue(entityClass));
    }

    public DocumentResultWrapper<E> findHits(SimpleQuery<SearchDocDTO> simpleQuery){
        return getRepository().findHits(SearchDocQueryFactory.searchDoc(simpleQuery.toSearchDoc()).create());
    }

    public E findRecentDocByRecentId(Serializable serializable) {
        return getRepository().findRecentDocByRecentId(serializable);
    }

    public <U extends Serializable> E findDocById(U id) {
        return getRepository().findDocById(id);
    }

    public <U extends Serializable> DocumentResultWrapper<E> findRecentDocById(U id) {
        return getRepository().findRecentDocById(id);
    }

    public List<E> findDocsByScrollApi(SimpleQuery<SearchDocDTO> simpleQuery) {
        return getRepository().findDocsByScrollApi(SearchDocQueryFactory.searchDoc(simpleQuery.toSearchDoc()).create());
    }

    public List<E> findRecentDocsByScrollApi(SimpleQuery<SearchDocDTO> simpleQuery) {
        return getRepository().findRecentDocsByScrollApi(SearchDocQueryFactory.searchDoc(simpleQuery.toSearchDoc()).createForRecentTrue(entityClass));
    }

    public DocumentResultWrapper<E> findRecentDocsBySearchAfter(SimpleQuery<SearchDocDTO> simpleQuery) {
        return getRepository().findRecentDocsBySearchAfter(SearchDocQueryFactory.searchDoc(simpleQuery.toSearchDoc()).createForRecentTrue(entityClass),simpleQuery.toSearchDoc().getSearchAfter());
    }

    public DocumentResultWrapper<E> findDocsBySearchAfter(SimpleQuery<SearchDocDTO> simpleQuery) {
        return getRepository().findDocsBySearchAfter(SearchDocQueryFactory.searchDoc(simpleQuery.toSearchDoc()).create(),simpleQuery.toSearchDoc().getSearchAfter());
    }

    public String indexAliasName(){
        return getRepository().indexAliasName();
    }

    public void deleteIndexWithDayRange(int days){
        getRepository().deleteIndexWithDayRange(days);
    }

    public void mergeWithReindex(int day){
        getRepository().mergeWithReindex(day);
    }

    public E save(E entity){
        return getRepository().save(entity);
    }

    public E modifyWithIndexName(E entity,String indexName){
        return getRepository().modifyWithIndexName(entity,indexName);
    }

    public E saveEmpty(E entity){
        return getRepository().saveEmpty(entity);
    }

    public <U extends Serializable> String deleteById(U u) {
        E docById = this.findDocById(u);
        return getRepository().deleteDocByEntity(docById);
    }

    public <U extends Serializable> Serializable deleteRecentDocById(U u) {
        return getRepository().deleteRecentDocById(u);
    }

    public DocumentResultWrapper<E> findAllHits() {
        return getRepository().findAllHits();
    }

    public DocumentResultWrapper<E> findRecentAllHits() {
        return getRepository().findRecentAllHits();
    }

    public List<CatIndexVO> catIndexVOList() {
         return getRepository().catIndexVOList();
    }

    public Long indexAllCount() {
        return getRepository().indexCount();
    }





}
