package com.arms.api.blog.controller;

import com.arms.api.blog.model.entity.BlogDTO;
import com.arms.api.blog.model.entity.BlogEntity;
import com.arms.api.blog.model.vo.BlogVO;
import com.arms.api.blog.service.BlogService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/engine/blog")
@Slf4j
@AllArgsConstructor
public class BlogController {

    private final BlogService blogService;

    @PostMapping
    public ResponseEntity<Long> addBlog(@RequestBody BlogDTO blogDTO) {
        return ResponseEntity.ok(blogService.addBlog(blogDTO));
    }

    @PutMapping
    public ResponseEntity<Long> updateBlog(@RequestBody BlogDTO blogDTO) {
        return ResponseEntity.ok(blogService.updateBlog(blogDTO));
    }

    @DeleteMapping("/{c_id}")
    public ResponseEntity<Long> removeBlog(@PathVariable Long c_id) {
        return ResponseEntity.ok(blogService.removeBlog(c_id));
    }

    // [GET] 길이가 긴 contents를 처리하기 위해 POST로 처리
    @PostMapping("/get")
    public ResponseEntity<BlogEntity> getBlog(@RequestBody BlogDTO blogDTO) {
        return ResponseEntity.ok(blogService.getBlog(blogDTO));
    }

    // [GET] 길이가 긴 contents를 처리하기 위해 POST로 처리
    @PostMapping("/popular")
    public ResponseEntity<List<BlogEntity>> getBlogListByViewCountDesc(@RequestBody BlogDTO blogDTO) {
        return ResponseEntity.ok(blogService.getBlogListByViewCountDesc(blogDTO));
    }

    // [GET] 길이가 긴 contents를 처리하기 위해 POST로 처리
    @PostMapping("/search")
    public ResponseEntity<BlogVO> getBlogListBySearchAfter(@RequestBody BlogDTO blogDTO) {
        return ResponseEntity.ok(blogService.searchBlog(blogDTO));
    }

}
