# CKEditor LiveEdit 플러그인

**CKEditor**에 **실시간 협업 편집 기능**을 추가해주는 플러그인입니다.

---

## 🚀 빠른 시작

1. `plugin.js` 파일을 CKEditor의 `plugins` 폴더 내 `liveedit` 폴더에 넣습니다.

2. 또는 아래처럼 수동으로 플러그인을 로드할 수 있습니다:

```javascript
CKEDITOR.plugins.addExternal('liveedit', '/modules/wiki/assets/ckeditorplugins/liveedit/', 'plugin.js');
```

3. 에디터 초기화 시 다음과 같이 설정합니다:

```javascript
CKEDITOR.replace('editorElementId', {
  extraPlugins: 'liveedit',
  // 기타 설정
});
```

---

## 💾 영속 저장소 연동

백엔드와 연동되도록 설계되었으며, **cmfive CRM REST 모듈** 기반이나 다른 시스템도 지원 가능합니다.

두 가지 **JSON 기반**의 엔드포인트가 필요합니다:

### 1. Poll 엔드포인트 (GET)

다른 사용자의 변경 내용을 주기적으로 가져옵니다.

- **URL 예시:**
```javascript
pollUrl: '/rest/index/WikiPage/id___equal/123/dt_modified___greater/',
```

- **응답 JSON 포맷:**
```json
{
  "success": [
    { "body": "...", "dt_modified": "..." },
    ...
  ]
}
```

- 추가 요청 파라미터(예: 토큰):
```javascript
requestParameters: 'token=' + token.success
```

- 요청 간격(ms):
```javascript
pollTimeOut: 3000
```

- 업데이트 수신 시 호출되는 함수:
```javascript
updateCallBack: 'my_updateCallBack'
```

### 2. Save 엔드포인트 (POST)

사용자의 편집 내용을 저장합니다.

- **URL 예시:**
```javascript
saveUrl: '/rest/save/WikiPage/',
```

- **추가 POST 데이터:**
```javascript
saveData: { "id": "123" }
```

- 입력이 멈춘 뒤 저장 대기 시간(ms):
```javascript
saveTimeOut: 2000
```

- 저장 시작 전 호출되는 함수:
```javascript
changeCallBack: 'my_changeCallBack'
```

- 저장 완료 후 호출되는 함수:
```javascript
saveCallBack: 'my_saveCallBack'
```

---

## 🔁 콜백 함수 정의 (전역 스코프)

```javascript
function my_updateCallBack(record) {
  $('#viewbody').html(record.body);
}

function my_changeCallBack() {
  $('#wikiautosavebuttons').show();
  $('#wikiautosavebuttons .savebutton').show();
  $('#wikiautosavebuttons .savedbutton').hide();
}

function my_saveCallBack(record) {
  $('#viewbody').html(record.body);
  $('#wikiautosavebuttons .savebutton').hide();
  $('#wikiautosavebuttons .savedbutton').show();
}
```

---

## 🧑‍💻 전체 초기화 예시

```javascript
$(document).ready(function() {
  CKEDITOR.plugins.addExternal('liveedit', '/modules/wiki/assets/ckeditorplugins/liveedit/', 'plugin.js');
  CKEDITOR.config.extraPlugins = 'liveedit';

  // 인증 토큰 요청
  $.ajax("/rest/token?apikey=YOUR_API_KEY", {
    cache: false,
    dataType: "json"
  }).done(function(token) {
    $('#body').each(function() {
      CKEDITOR.replace(this, {
        lastModified: 'LAST_MODIFIED_VALUE',
        pollUrl: '/rest/index/WikiPage/id___equal/123/dt_modified___greater/',
        saveUrl: '/rest/save/WikiPage/',
        updateCallBack: 'my_updateCallBack',
        changeCallBack: 'my_changeCallBack',
        saveCallBack: 'my_saveCallBack',
        saveTimeOut: 2000,
        pollTimeOut: 3000,
        requestParameters: 'token=' + token.success,
        saveData: { "id": "123" }
      });
    });
  });
});
```

---

## 📄 라이선스

MIT 또는 기존 라이선스에 따름.