////////////////////////////////////////////////////////////////////////////////////////
//Document Ready
////////////////////////////////////////////////////////////////////////////////////////
function execDocReady() {
	var pluginGroups = [
		["../reference/light-blue/lib/vendor/jquery.ui.widget.js", "../reference/lightblue4/docs/lib/widgster/widgster.js"],
		[
			"../reference/lightblue4/docs/lib/parsleyjs/dist/parsley.min.js",
			"../reference/lightblue4/docs/lib/parsleyjs/dist/i18n/ko.js"
		]
		// 추가적인 플러그인 그룹들을 이곳에 추가하면 됩니다.
	];

	loadPluginGroupsParallelAndSequential(pluginGroups)
		.then(function () {
			console.log("모든 플러그인 로드 완료");

			$(".widget").widgster();

			var urlParams = new URL(location.href).searchParams;
			var id = urlParams.get("id");
			var path;
			var editor;

			var waitCKEDITOR = setInterval(function () {
				try {
					if (window.CKEDITOR) {
						if (window.CKEDITOR.status === "loaded") {
							editor = CKEDITOR.replace("editor", { contentsCss: "./css/contents.css" });
							clearInterval(waitCKEDITOR);
						}
					}
				} catch (err) {
					console.log("CKEDITOR 로드가 완료되지 않아서 초기화 재시도 중...");
				}
			}, 313 /*milli*/);

			var postComponents = (function () {
				return {
					loading: function () {
						return $(
							`<div class="panel panel-default">
								<div class="panel-body util-animate-pulse">
									<div class="clearfix">
										<div class="pull-right dark:util-bg-gray-700s util-h-2.5 util-w-64 util-rounded-full util-bg-gray-200"></div>
									</div>

									<h3 class="util-mb-8 util-h-4 util-w-48 util-rounded-full util-bg-gray-300 dark:util-bg-gray-600"></h3>

									<div class="util-h-2.5 util-w-full util-rounded-full util-bg-gray-200 dark:util-bg-gray-700"></div>
								</div>
							</div>`
						);
					},
					main: function (post) {
						return $(
							`<div class="panel panel-default">
								<div class="panel-body">
									<div class="clearfix">
										<span class="util-mr-2">${post.userName}</span>
										<span class="text-muted">
											<span class="util-mr-2">
												<i class="fa-solid fa-eye ml-2"></i>
												${post.viewCount || 0}
											</span>
											<span>${new Date(post.createdDate).toLocaleString()}</span>
										</span>

										<div class="dropdown pull-right">
											<button
												class="btn btn-default dropdown-toggle util-border-none"
												type="button"
												id="dropdownMenu-${post.id}"
												data-toggle="dropdown"
												aria-haspopup="true"
												aria-expanded="true">
												<i class="fa-solid fa-ellipsis-vertical"></i>
											</button>
											<ul
												class="dropdown-menu"
												aria-labelledby="dropdownMenu-${post.id}">
												<li>
													<a
														href="#modal_update_board"
														data-toggle="modal"
														data-board-id="${post.id}">
														수정
														<i class="fa-solid fa-pen"></i>
													</a>
												</li>
												<li>
													<a
														href="#modal_delete_board"
														data-toggle="modal"
														data-board-id="${post.id}"
														data-post-type="${post.postType}">
														삭제
														<i class="fa-solid fa-trash-can"></i>
													</a>
												</li>
											</ul>
										</div>
									</div>

									<h3 class="util-mb-8">${post.subjectName}</h3>

									<div>${post.contents}</div>
								</div>
							</div>`
						);
					}
				};
			})();

			var replyComponents = (function () {
				return {
					loading: function () {
						return $(
							`<div class="media bg-fill-base border-base util-m-0 util-border-b util-p-4">
								<div class="media-body">
									<div class="media-heading clearfix util-mb-4">
										<h3 class="util-mb-8 util-h-4 util-w-48 util-rounded-full util-bg-gray-300 dark:util-bg-gray-600"></h3>
									</div>

									<div class="util-h-2.5 util-w-full util-rounded-full util-bg-gray-200 dark:util-bg-gray-700"></div>
								</div>
							</div>`
						);
					},
					main: function (reply) {
						return $(
							`<div class="media bg-fill-base border-base util-m-0 util-overflow-visible util-border-b util-p-4">
								<div class="media-body util-overflow-visible">
									<div class="media-heading clearfix util-mb-4">
										<span class="util-mr-2">${reply.userName}</span>
										<span class="text-muted">${new Date(reply.createdDate).toLocaleString()}</span>

										<div class="dropdown pull-right">
											<button
												class="btn btn-default dropdown-toggle util-border-none"
												type="button"
												id="dropdownMenu-${reply.id}"
												data-toggle="dropdown"
												aria-haspopup="true"
												aria-expanded="true">
												<i class="fa-solid fa-ellipsis-vertical"></i>
											</button>
											<ul
												class="dropdown-menu"
												aria-labelledby="dropdownMenu-${reply.id}">
												<li>
													<a
														href="#modal_delete_board"
														data-toggle="modal"
														data-board-id="${reply.id}"
														data-post-type="${reply.postType}">
														삭제
														<i class="fa-solid fa-trash-can"></i>
													</a>
												</li>
											</ul>
										</div>
									</div>

									<div>${reply.contents}</div>
								</div>
							</div>`
						);
					},
					noData: function () {
						return $(
							`<div class="media bg-fill-base border-base util-m-0 util-border-b util-p-4">
								<div class="media-body">
									<p class="text-center util-m-0">
										<i class="fa-solid fa-comment-slash"></i>
										등록된 댓글이 없습니다.
									</p>
								</div>
							</div>`
						);
					}
				};
			})();

			var drawBoard = function (id) {
				var $postDetail = $("#post_detail");
				var $replyList = $("#reply_list");

				$.ajax({
					url: "/bbs/find-path/find-id/" + id,
					type: "GET",
					beforeSend: function () {
						$postDetail.html(postComponents.loading());
						$replyList.html(replyComponents.loading());
					},
					success: function (data) {
						path = data.response[0].path;

						var board = data.response.reduce(
							function (_boardList, _board) {
								if (_board.postType === "POST") {
									_boardList.detail = _board;
									return _boardList;
								}

								_boardList.reply = _boardList.reply.concat(_board);
								return _boardList;
							},
							{ detail: {}, reply: [] }
						);

						$postDetail.html(postComponents.main(board.detail));

						if (board.reply.length <= 0) {
							$replyList.html(replyComponents.noData());
							return;
						}

						$replyList.empty();
						board.reply.forEach(function (_reply) {
							$replyList.append(replyComponents.main(_reply));
						});
					}
				});
			};

			drawBoard(id);

			$("#reply_form").on("submit", function (event) {
				event.preventDefault();

				$.ajax({
					url: "/bbs/verify/captcha",
					type: "POST",
					contentType: "application/json;charset=utf-8",
					data: JSON.stringify({ captcha: $("#input_captcha").val() }),
					success: function () {
						var formData = Object.fromEntries(new FormData(event.target));
						formData.contents = editor.getData();
						formData.path = path;
						formData.boardType = "LANDING";

						$.ajax({
							url: "/bbs/reply-message",
							type: "POST",
							contentType: "application/json;charset=utf-8",
							data: JSON.stringify(formData),
							success: function () {
								$(event.target).trigger("reset");
								$("#board_list").empty();
								editor.setData("");
								drawBoard(id);
							}
						});
					},
					error: function (xhr) {
						jError("캡차 인증에 실패했습니다. 다시 시도해주세요.: " + (xhr.responseJSON?.error || "알 수 없는 오류"));
					}
				});

				return false;
			});

			$("#btn_refresh_captcha").on("click", function () {
				$("#captcha").attr("src", "/bbs/verify/image?_t=" + new Date().getTime());
			});

			(function () {
				var $modalDeleteBoard = $("#modal_delete_board");
				var $formDeleteBoard = $("#form_delete_board");
				var targetId = "";
				var postType = "";

				$modalDeleteBoard
					.on("shown.bs.modal", function (event) {
						var $relatedTarget = $(event.relatedTarget);

						targetId = $relatedTarget.data("board-id");
						postType = $relatedTarget.data("post-type");
					})
					.on("hidden.bs.modal", function () {
						$formDeleteBoard.trigger("reset");
					});

				$formDeleteBoard.on("submit", function (event) {
					event.preventDefault();

					var formData = Object.fromEntries(new FormData(event.target));
					formData.id = targetId;

					$.ajax({
						url: "/bbs/check-password",
						type: "POST",
						contentType: "application/json;charset=utf-8",
						data: JSON.stringify(formData),
						success: function () {
							$modalDeleteBoard.modal("hide");

							$.ajax({
								url: "/bbs/delete-id/" + targetId,
								type: "DELETE",
								beforeSend: function () {
									if (postType === "POST") {
										$("#post_detail").html(postComponents.loading());
									} else {
										$("#reply_list").html(replyComponents.loading());
									}
								},
								success: function () {
									if (postType === "POST") {
										location.replace("/cover/template.html?page=board");
									} else {
										drawBoard(id);
									}
								}
							});
						},
						error: function (error) {
							jError(error.responseJSON.error.message);
						}
					});

					return false;
				});
			})();

			(function () {
				var $modalUpdateBoard = $("#modal_update_board");
				var $formUpdateBoard = $("#form_update_board");
				var targetId = "";

				$modalUpdateBoard
					.on("shown.bs.modal", function (event) {
						targetId = $(event.relatedTarget).data("board-id");
					})
					.on("hidden.bs.modal", function () {
						$formUpdateBoard.trigger("reset");
					});

				$formUpdateBoard.on("submit", function (event) {
					event.preventDefault();

					var formData = Object.fromEntries(new FormData(event.target));
					formData.id = targetId;

					$.ajax({
						url: "/bbs/check-password",
						type: "POST",
						contentType: "application/json;charset=utf-8",
						data: JSON.stringify(formData),
						success: function () {
							$modalUpdateBoard.modal("hide");
							location.href = "/cover/template.html?page=question&id=" + targetId;
						},
						error: function (error) {
							jError(error.responseJSON.error.message);
						}
					});

					return false;
				});
			})();
		})
		.catch(function (error) {
			console.error("플러그인 로드 중 오류 발생");
			console.error(error);
		});
}
