/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.gcframework.service;

import com.arms.config.GiteaUserConfig;
import com.arms.egovframework.javaservice.gcframework.model.AbstractContentVO;
import com.arms.egovframework.javaservice.gcframework.model.FileContent;
import com.arms.egovframework.javaservice.gcframework.model.GitFileInfo;
import com.arms.egovframework.javaservice.gcframework.model.RepoType;
import com.arms.egovframework.javaservice.gcframework.parser.AbstractContentParser;
import com.arms.egovframework.javaservice.gcframework.provider.GitRepositoryProvider;
import com.arms.egovframework.javaservice.gcframework.service.GitFileService;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GitFileServiceImpl
implements GitFileService {
    private static final Logger log = LoggerFactory.getLogger(GitFileServiceImpl.class);
    private final GiteaUserConfig giteaUserConfig;
    private final Map<RepoType, GitRepositoryProvider> providers;
    private final Map<String, AbstractContentParser<?>> parsers;

    public GitFileServiceImpl(GiteaUserConfig giteaUserConfig, List<GitRepositoryProvider> providers, List<AbstractContentParser<?>> parsers) {
        this.giteaUserConfig = giteaUserConfig;
        this.providers = providers.stream().collect(Collectors.toMap(GitRepositoryProvider::getType, Function.identity()));
        this.parsers = parsers.stream().collect(Collectors.toMap(AbstractContentParser::getHandledType, Function.identity()));
    }

    public FileContent getFileContent(RepoType repoType, String repoName, String filePath) {
        GitRepositoryProvider provider = (GitRepositoryProvider)this.providers.get(repoType);
        if (provider == null) {
            throw new IllegalArgumentException("Unsupported repository type: " + String.valueOf(repoType));
        }
        String owner = this.giteaUserConfig.getOwner();
        String branch = this.giteaUserConfig.getGitBranch();
        log.debug("Getting file content from repo '{}', path '{}'", (Object)repoName, (Object)filePath);
        return provider.getFileContent(owner, repoName, branch, filePath);
    }

    public <T extends AbstractContentVO> boolean upsertFileContent(RepoType repoType, String repoName, String filePath, T configVo, String commitMessage) {
        GitRepositoryProvider provider = (GitRepositoryProvider)this.providers.get(repoType);
        if (provider == null) {
            throw new IllegalArgumentException("Unsupported repository type: " + String.valueOf(repoType));
        }
        String fileExtension = this.getFileExtension(filePath);
        AbstractContentParser parser = (AbstractContentParser)this.parsers.get(fileExtension);
        if (parser == null) {
            throw new UnsupportedOperationException("No parser found for file type: " + fileExtension);
        }
        String contentToSave = parser.serialize(configVo);
        String owner = this.giteaUserConfig.getOwner();
        String branch = this.giteaUserConfig.getGitBranch();
        log.debug("Upserting file content to repo '{}', path '{}'", (Object)repoName, (Object)filePath);
        return provider.upsertFile(owner, repoName, branch, filePath, contentToSave, commitMessage);
    }

    public List<GitFileInfo> listFilesAndDirectories(RepoType repoType, String repoName, String directoryPath) {
        GitRepositoryProvider provider = (GitRepositoryProvider)this.providers.get(repoType);
        if (provider == null) {
            throw new IllegalArgumentException("Unsupported repository type: " + String.valueOf(repoType));
        }
        String owner = this.giteaUserConfig.getOwner();
        String branch = this.giteaUserConfig.getGitBranch();
        log.debug("Listing files and directories in repo '{}', path '{}'", (Object)repoName, (Object)directoryPath);
        return provider.getListFilesAndDirectories(owner, repoName, directoryPath, branch);
    }

    public boolean deleteFile(RepoType repoType, String repoName, String filePath, String commitMessage) {
        GitRepositoryProvider provider = (GitRepositoryProvider)this.providers.get(repoType);
        if (provider == null) {
            throw new IllegalArgumentException("Unsupported repository type: " + String.valueOf(repoType));
        }
        String owner = this.giteaUserConfig.getOwner();
        String branch = this.giteaUserConfig.getGitBranch();
        log.debug("Deleting file from repo '{}', path '{}'", (Object)repoName, (Object)filePath);
        return provider.deleteFile(owner, repoName, branch, filePath, commitMessage);
    }

    public <T extends AbstractContentVO> T parseFileContent(FileContent fileContent, String filePath, Class<T> targetVoType) {
        if (fileContent == null || fileContent.getContent() == null) {
            log.warn("Attempted to parse null or empty file content for path: {}", (Object)filePath);
            return null;
        }
        String fileExtension = this.getFileExtension(filePath);
        AbstractContentParser parser = (AbstractContentParser)this.parsers.get(fileExtension);
        if (parser == null) {
            throw new UnsupportedOperationException("No parser found for file type: " + fileExtension);
        }
        log.debug("Parsing file content for path '{}' with parser type '{}'", (Object)filePath, (Object)fileExtension);
        return (T)parser.parse(fileContent.getContent(), targetVoType);
    }

    private String getFileExtension(String filePath) {
        int dotIndex = filePath.lastIndexOf(46);
        return dotIndex == -1 || dotIndex == filePath.length() - 1 ? "" : filePath.substring(dotIndex + 1).toLowerCase();
    }
}

