package com.arms.egovframework.javaservice.esframework.model.dto.esquery;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@Setter
@Getter
@AllArgsConstructor
@NoArgsConstructor
public class SortDTO {

	private String field;

	private String sortType;

	public static SortDTOBuilder builder() {
		return new SortDTOBuilder();
	}

	public static class SortDTOBuilder {
		private String field;
		private String sortType;

		public SortDTOBuilder field(String field) {
			this.field = field;
			return this;
		}

		public SortDTOBuilder sortType(String sortType) {
			this.sortType = sortType;
			return this;
		}

		public SortDTO build() {
			SortDTO dto = new SortDTO();
			dto.setField(this.field);
			dto.setSortType(this.sortType);
			return dto;
		}
	}
}
