package com.arms.api.analysis.resource.model.vo.sankey;

import lombok.*;

@Getter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class VersionAssigneeSummaryVO {

    private String versionAccountId;
    private Long versionId;
    private String accountId;
    private String name;
    private String emailAddress;
    private Long totalIssue;
    @Setter
    private Long reqIssueCount;
    @Setter
    private Long notReqIssueCount;

    public void setVersionAccountId(Long versionId, String accountId) {
        this.versionAccountId = versionId + "_" + accountId;
    }

    public void addReqIssueCount() { reqIssueCount++; }
    public void addNotReqIssueCount() { notReqIssueCount++; }

    public void sumReqIssueCountToTotal(Long reqIssueCount) {
        totalIssue += reqIssueCount;
    }
    public void sumNotReqIssueCountToTotal(Long notReqIssueCount) {
        totalIssue += notReqIssueCount;
    }
}
