/*
 * Decompiled with CFR 0.152.
 */
package com.arms.config;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@RefreshScope
public class WebConfig
implements WebMvcConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebConfig.class);
    @Value(value="${cors.allowed-origins}")
    private String allowedOrigins;

    public void addCorsMappings(CorsRegistry registry) {
        String[] origins;
        for (String origin : origins = this.allowedOrigins.split(",")) {
            log.info("CORS Allowed Origin: {}", (Object)origin);
        }
        registry.addMapping("/api/**").allowedOrigins(origins).allowedMethods(new String[]{"GET", "POST", "PUT", "DELETE", "PATCH", "OPTIONS"}).allowedHeaders(new String[]{"*"}).allowCredentials(true).maxAge(3600L);
    }
}

