/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.wiki.controller;

import com.arms.api.wiki.dto.ChatMessage;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Controller;

@Controller
public class ChatController {
    private static final Logger log = LoggerFactory.getLogger(ChatController.class);
    private final SimpMessagingTemplate messagingTemplate;

    @Autowired
    public ChatController(SimpMessagingTemplate messagingTemplate) {
        this.messagingTemplate = messagingTemplate;
    }

    @MessageMapping(value={"/chat"})
    public void handleChatMessage(@Payload ChatMessage chatMessage) {
        String sessionId = chatMessage.getSessionId();
        if (sessionId == null || chatMessage.getUserId() == null || chatMessage.getMessage() == null) {
            log.warn("Invalid chat message received: {}", (Object)chatMessage);
            return;
        }
        if (chatMessage.getTimestamp() == null) {
            chatMessage.setTimestamp(LocalDateTime.now());
        }
        log.info("Received chat message in session [{}] from user [{}]: {}", new Object[]{sessionId, chatMessage.getUserName(), chatMessage.getMessage().substring(0, Math.min(50, chatMessage.getMessage().length()))});
        String destination = String.format("/topic/sessions/%s/chat", sessionId);
        this.messagingTemplate.convertAndSend((Object)destination, (Object)chatMessage);
        log.debug("Sent chat message to {}", (Object)destination);
    }
}

