////////////////////////////////////////////////////////////////////////////////////////
//Document Ready
////////////////////////////////////////////////////////////////////////////////////////
function onChangeTab() {
	$(".tab-item").on("click", function () {
		$(".tab-item").removeClass("active");
		$(this).addClass("active");

		var target = $(this).data("target");

		$(".tab-content").removeClass("active");
		$("#" + target).addClass("active");

		scrollToTop();
	});
}

/**
 * 화면 최상단으로 자연스럽게 스크롤
 */
function scrollToTop() {
	requestAnimationFrame(() => {
		// 구형과 신형 브라우저 구분 처리
		if ("scrollBehavior" in document.documentElement.style) {
			window.scrollTo({ top: 0, behavior: "smooth" });
		} else {
			$("html, body").stop(true).animate({ scrollTop: 0 }, 300);
		}
	});
}

/**
 * 특정 스크롤 아래로 내려가면 탭을 상단에 고정합니다.
 */
function onScrollFixTab() {
	var tabTop = 280;

	$(window).on("scroll", function () {
		if ($(window).scrollTop() >= tabTop) {
			$(".tab-component").addClass("sticky");
		} else {
			$(".tab-component").removeClass("sticky");
		}
	});
}

function loadFunctionCSS(hrefList) {
	// 배열을 반복하면서 link 태그 추가
	hrefList.forEach(function (href) {
		var cssLink = $("<link>").attr({
			type: "text/css",
			rel: "stylesheet",
			href: href
		});
		$("head").append(cssLink);
	});
}

function onToggleFaqAccordion() {
	$(".faq-question").on("click", function () {
		var parent = $(this).closest(".faq-item");

		parent.toggleClass("active");
		parent.find(".faq-answer").slideToggle(200);

		var icon = parent.find(".toggle-icon");
		icon.text(icon.text() === "+" ? "×" : "+");
	});
}

function execDocReady() {
	var pluginGroups = [
		["../reference/light-blue/lib/vendor/jquery.ui.widget.js", "../reference/lightblue4/docs/lib/widgster/widgster.js"],
		["../reference/lightblue4/docs/lib/bootstrap-select/dist/js/bootstrap-select.min.js"]
		// 추가적인 플러그인 그룹들을 이곳에 추가하면 됩니다.
	];

	loadPluginGroupsParallelAndSequential(pluginGroups)
		.then(function () {
			loadFunctionCSS([
				"css/function/layout.css",
				"css/function/component/tab.css",
				"css/function/component/tab-content.css"
			]);
			$("#sidebar").hide();
			$(".wrap").css("margin-left", 0);
			$(".widget").widgster();
			$("#footer").load("/cover/html/template/landing-footer.html");

			onChangeTab();
			onToggleFaqAccordion();
		})
		.then(function () {
			onScrollFixTab();
		})
		.catch(function (error) {
			console.error("플러그인 로드 중 오류 발생");
			console.error(error);
		});
}
