package com.arms.api.schedule.service;

import com.arms.api.schedule.model.dto.ScheduleInfoDTO;
import com.arms.api.schedule.model.vo.ScheduleDetailVO;
import com.arms.api.schedule.model.vo.ScheduleHistoryVO;
import com.arms.api.schedule.model.vo.ScheduleMapVO;
import com.arms.api.util.external_communicate.dto.SearchDTO;

import java.util.List;

public interface ScheduleService  {

    void almIssueMergeWithReindex();

    void fluentdMergeWithReindex();

    void almIssueMergeWithReindex(int day);

    void fluentdMergeWithReindex(int day);

    void serverInfoBackup();

    void executeIncrementalIssueWithDateRangeSequentialSchedules(String startDate, String endDate);

    void executeSequentialSchedules();

    void updateReqStatusFromElasticsearch();

    ScheduleMapVO getScheduleList() throws Exception;

    List<ScheduleDetailVO> getCurrentScheduleList();

    String saveScheduleList(String fileName, List<ScheduleInfoDTO> scheduleList) throws Exception;

    List<ScheduleHistoryVO> getScheduleHistory(SearchDTO searchDTO);

    void retryFailedReqStatusCreationToElasticsearch();

    void cacheStatusMappingData();

    void updateArmsStateCategory();

    void cloudJiraTestApiRequest();
}
