package com.arms.egovframework.javaservice.esframework.model.entity;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;

import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.ReadOnlyProperty;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchUpdateDate;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.Setter;

@Data
@Builder
@AllArgsConstructor
@Document(indexName = "indexstatus")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "_class")
@JsonTypeName("com.arms.egovframework.javaservice.esframework.model.entity.IndexStatusEntity")
@JsonIgnoreProperties(ignoreUnknown = true)
public class IndexStatusEntity implements BaseEntity {

    private IndexStatusEntity(){
    }

    @Id
    @ReadOnlyProperty
    private String id;

    @Field(type = FieldType.Keyword, name = "index_alias")
    private String indexAlias;

    @Field(type = FieldType.Keyword)
    private String index;

    @Field(type = FieldType.Keyword, name = "job_id")
    private String jobId;

    @Field(type = FieldType.Date, name = "@timestamp")
    @JsonProperty("@timestamp")
    @ElasticSearchUpdateDate
    private Date timestamp;

    @Field(type = FieldType.Text)
    private String health;

    @Field(type = FieldType.Text)
    private String status;

    @Field(type = FieldType.Long, name = "docs_count")
    private Long docsCount;

    @Field(type = FieldType.Keyword, name = "job_status")
    private JobStatus jobStatus;


}
