package com.arms.api.issue.resolution.service;

import com.arms.api.issue.resolution.model.IssueResolutionData;
import com.arms.api.issue.resolution.strategy.OnPremiseJiraIssueResolutionStrategy;
import com.arms.api.issue.resolution.strategy.IssueResolutionStrategy;
import com.arms.api.issue.resolution.strategy.IssueResolutionStrategyRegister;
import com.arms.api.issue.resolution.strategy.CloudJiraIssueResolutionStrategy;
import com.arms.api.util.errors.ErrorCode;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.model.enums.ServerType;
import com.arms.api.serverinfo.service.ServerInfoService;

import lombok.RequiredArgsConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;

@Service
@RequiredArgsConstructor
public class 이슈해결책_전략_호출 {

    private final Logger 로그 = LoggerFactory.getLogger(this.getClass());

    private ServerInfoService ServerInfoService;
    private CloudJiraIssueResolutionStrategy 클라우드_지라_이슈해결책_전략;
    private OnPremiseJiraIssueResolutionStrategy 온프레미스_지라_이슈해결책_전략;

    @Autowired
    public 이슈해결책_전략_호출(ServerInfoService ServerInfoService,
                       CloudJiraIssueResolutionStrategy 클라우드_지라_이슈해결책_전략,
                       OnPremiseJiraIssueResolutionStrategy 온프레미스_지라_이슈해결책_전략) {

        this.ServerInfoService = ServerInfoService;
        this.클라우드_지라_이슈해결책_전략 = 클라우드_지라_이슈해결책_전략;
        this.온프레미스_지라_이슈해결책_전략 = 온프레미스_지라_이슈해결책_전략;
    }

    private IssueResolutionStrategy 이슈해결책_전략_확인(ServerInfo serverInfo) {

        if (serverInfo == null || serverInfo.getType().isEmpty()) {
            로그.error("지라이슈 해결책 전략 등록 Error: serverInfo 유형 {}", ErrorCode.SERVER_TYPE_INFO_ERROR.getErrorMsg());
            throw new IllegalArgumentException("지라이슈 해결책 전략 등록 Error: 연결정보_유형 " + ErrorCode.SERVER_TYPE_INFO_ERROR.getErrorMsg());
        }

        ServerType 서버_유형 = ServerType.typeValueOf(serverInfo.getType());

        IssueResolutionStrategy IssueResolutionStrategy;
        if (서버_유형 == ServerType.CLOUD) {
            IssueResolutionStrategy = this.클라우드_지라_이슈해결책_전략;
        }
        else if (서버_유형 == ServerType.ON_PREMISS) {
            IssueResolutionStrategy = this.온프레미스_지라_이슈해결책_전략;
        }
        else {
            throw new IllegalArgumentException("이슈해결책 전략 확인 Error: 허용하지 않는 serverInfo_유형입니다. :: "+ 서버_유형+ " :: " + ErrorCode.SERVER_TYPE_INFO_ERROR.getErrorMsg());
        }

        return IssueResolutionStrategy;

    }

    public List<IssueResolutionData> 이슈해결책_목록_가져오기(String 연결_아이디) {

        if (연결_아이디 == null) {
            로그.error("이슈 해결책 목록 가져오기 Error: 연결_아이디 {}", ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg());
            throw new IllegalArgumentException("이슈 해결책 목록 가져오기 Error: 연결_아이디 " + ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg());
        }

        ServerInfo serverInfo = ServerInfoService.verifyServerInfo(연결_아이디);

        ServerType 서버_유형 = ServerType.typeValueOf(serverInfo.getType());

        if (서버_유형 == ServerType.REDMINE_ON_PREMISS) {
            로그.info("레드마인 온프레미스 타입은 이슈 해결책을 지원하지 않습니다.");
            return Collections.emptyList();
        }

        IssueResolutionStrategy IssueResolutionStrategy = 이슈해결책_전략_확인(serverInfo);
        IssueResolutionStrategyRegister IssueResolutionStrategyRegister = new IssueResolutionStrategyRegister();
        IssueResolutionStrategyRegister.issueResolutionStrategyRegister(IssueResolutionStrategy);

        List<IssueResolutionData> 반환할_이슈해결책_목록
                = IssueResolutionStrategyRegister.getIssueResolutionStrategyList(serverInfo);

        return 반환할_이슈해결책_목록;

    }
}
