package com.arms.api.analysis.time.controller;

import com.arms.api.analysis.time.dto.TimeAggrDTO;
import com.arms.api.analysis.time.dto.TimeDTO;
import com.arms.api.analysis.time.service.AnalysisTime;
import com.arms.api.analysis.time.vo.AlmIssueStatVO;
import com.arms.api.analysis.time.vo.HeatMapVO;
import com.arms.api.analysis.time.vo.RidgeLineVO;
import com.arms.api.analysis.time.vo.ScatterChartVO;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/engine/analysis-time")
@Slf4j
@AllArgsConstructor
public class AnalysisTimeController {

    private final AnalysisTime analysisTime;
    // 스캐터 차트
    @PostMapping("/updated-issue/scatter-data")
    public ResponseEntity<List<ScatterChartVO>> getScatterData(@RequestBody TimeDTO timeDTO) {
        return ResponseEntity.ok(analysisTime.getScatterData(timeDTO));
    }

    // 히트맵 차트(카디널리티 집계)
    @PostMapping("/updated-issue/heatmap-data")
    public ResponseEntity<HeatMapVO> getHeatMapDataByUpdated(@RequestBody TimeDTO timeDTO) {
        return ResponseEntity.ok(analysisTime.getHeatMapDataByUpdated(timeDTO));
    }

    // 카디널리티 집계 테스트용 API (method만 남기고 API 는 삭제 예정)
    @PostMapping("/updated-issue/heatmap-data-cardinality")
    public ResponseEntity<?> getHeatmapData(@RequestBody TimeDTO timeDTO) {
        return ResponseEntity.ok(analysisTime.getDateHistogramCardinalityData(timeDTO));
    }

    // 멀티 콤비네이션 차트
    @PostMapping("/updated-issue/multi-combination-data")
    public ResponseEntity<List<AlmIssueStatVO>> getMultiCombinationChartData(@RequestBody TimeDTO timeDTO) {
        return ResponseEntity.ok(analysisTime.getMultiCombinationChartData(timeDTO));
    }

    // 이슈 타임라인 차트 (vertical-timeline)
    @PostMapping("/updated-timeline")
    public ResponseEntity<List<AlmIssueEntity>> getUpdatedReqIssueByDateRange(@RequestBody TimeAggrDTO timeAggrDTO) {
        return ResponseEntity.ok(analysisTime.getUpdatedReqIssueByDateRange(timeAggrDTO));
    }

    // 능선 차트 - 버전별 일자(업데이트)별 이슈 - 리팩토링
    @PostMapping("/updated-ridgeline")
    public ResponseEntity<List<RidgeLineVO>> getRidgeLineData(@RequestBody TimeDTO timeDTO) {
        return ResponseEntity.ok(analysisTime.getRidgeLineData(timeDTO));
    }

}
