/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.type.service;

import com.arms.api.issue.type.strategy.CloudJiraIssueTypeStrategy;
import com.arms.api.issue.type.strategy.IssueTypeStrategy;
import com.arms.api.issue.type.strategy.IssueTypeStrategyFactory;
import com.arms.api.issue.type.strategy.OnpremiseJiraIssueTypeStrategy;
import com.arms.api.issue.type.strategy.OnpremiseRedmineIssueTypeStrategy;
import com.arms.api.issue.type.vo.IssueTypeVO;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.model.enums.ServerType;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.errors.ErrorCode;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IssueTypeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IssueTypeService.class);
    private final ServerInfoService ServerInfoService;
    private final CloudJiraIssueTypeStrategy cloudJiraIssueType;
    private final OnpremiseJiraIssueTypeStrategy onpremiseJiraIssueType;
    private final OnpremiseRedmineIssueTypeStrategy onpremiseRedmineIssueType;

    private IssueTypeStrategyFactory settingIssueTypeStrategy(ServerInfo serverInfo) {
        IssueTypeStrategy issueTypeStrategy;
        if (serverInfo == null || StringUtils.isEmpty((CharSequence)serverInfo.getType())) {
            log.error("settingIssueTypeStrategy Error: serverInfo \uc720\ud615 {}", (Object)ErrorCode.SERVER_TYPE_INFO_ERROR.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("settingIssueTypeStrategy Error: serverInfo \uc720\ud615 " + ErrorCode.SERVER_TYPE_INFO_ERROR.getErrorMsg(new Object[0]));
        }
        ServerType serverType = ServerType.typeValueOf(serverInfo.getType());
        if (serverType == ServerType.CLOUD) {
            issueTypeStrategy = this.cloudJiraIssueType;
        } else if (serverType == ServerType.ON_PREMISS) {
            issueTypeStrategy = this.onpremiseJiraIssueType;
        } else if (serverType == ServerType.REDMINE_ON_PREMISS) {
            issueTypeStrategy = this.onpremiseRedmineIssueType;
        } else {
            throw new IllegalArgumentException("settingIssueTypeStrategy Error: \ud5c8\uc6a9\ud558\uc9c0 \uc54a\ub294 serverInfo \uc720\ud615\uc785\ub2c8\ub2e4. :: " + String.valueOf((Object)serverType) + " :: " + ErrorCode.SERVER_TYPE_INFO_ERROR.getErrorMsg(new Object[0]));
        }
        IssueTypeStrategyFactory issueTypeStrategyFactory = new IssueTypeStrategyFactory();
        issueTypeStrategyFactory.registerIssueTypeStrategy(issueTypeStrategy);
        return issueTypeStrategyFactory;
    }

    public List<IssueTypeVO> getIssueTypeList(String connectId) {
        ServerInfo serverInfo = this.ServerInfoService.verifyServerInfo(connectId);
        ServerType serverType = ServerType.typeValueOf(serverInfo.getType());
        if (serverType == ServerType.CLOUD) {
            throw new IllegalArgumentException("\uc9c0\ub77c \ud074\ub77c\uc6b0\ub4dc \ud0c0\uc785\uc740 \uc774\uc288 \uc720\ud615 \ubaa9\ub85d \uac00\uc838\uc624\uae30\ub97c \uc0ac\uc6a9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        if (serverType == ServerType.REDMINE_ON_PREMISS) {
            throw new IllegalArgumentException("\ub808\ub4dc\ub9c8\uc778 \uc628\ud504\ub808\ubbf8\uc2a4 \ud0c0\uc785\uc740 \uc774\uc288 \uc720\ud615 \ubaa9\ub85d \uac00\uc838\uc624\uae30\ub97c \uc0ac\uc6a9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        IssueTypeStrategyFactory issueTypeStrategyFactory = this.settingIssueTypeStrategy(serverInfo);
        List<IssueTypeVO> returnIssueTypeList = issueTypeStrategyFactory.getIssueTypeList(serverInfo);
        return returnIssueTypeList;
    }

    public List<IssueTypeVO> getIssueTypeListByProject(String connectId, String projectId) {
        ServerInfo serverInfo = this.ServerInfoService.verifyServerInfo(connectId);
        ServerType serverType = ServerType.typeValueOf(serverInfo.getType());
        if (serverType == ServerType.ON_PREMISS) {
            throw new IllegalArgumentException("\uc9c0\ub77c \uc628\ud504\ub808\ubbf8\uc2a4 \ud0c0\uc785\uc740 \ud504\ub85c\uc81d\ud2b8\ubcc4 \uc774\uc288 \uc720\ud615 \ubaa9\ub85d \uac00\uc838\uc624\uae30\ub97c \uc0ac\uc6a9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        IssueTypeStrategyFactory issueTypeStrategyFactory = this.settingIssueTypeStrategy(serverInfo);
        List<IssueTypeVO> returnIssueTypeList = issueTypeStrategyFactory.getIssueTypeListByProject(serverInfo, projectId);
        return returnIssueTypeList;
    }

    @Generated
    public IssueTypeService(ServerInfoService ServerInfoService2, CloudJiraIssueTypeStrategy cloudJiraIssueType, OnpremiseJiraIssueTypeStrategy onpremiseJiraIssueType, OnpremiseRedmineIssueTypeStrategy onpremiseRedmineIssueType) {
        this.ServerInfoService = ServerInfoService2;
        this.cloudJiraIssueType = cloudJiraIssueType;
        this.onpremiseJiraIssueType = onpremiseJiraIssueType;
        this.onpremiseRedmineIssueType = onpremiseRedmineIssueType;
    }
}

