/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.analysis.cost.service;

import com.arms.api.analysis.cost.model.dto.AssigneeSalaryDTO;
import com.arms.api.analysis.cost.model.dto.CostAggrDTO;
import com.arms.api.analysis.cost.model.dto.CostDTO;
import com.arms.api.analysis.cost.model.dto.CostRequestDTO;
import com.arms.api.analysis.cost.model.vo.AssigneePerformanceVO;
import com.arms.api.analysis.cost.model.vo.AssigneeTimeDiffVO;
import com.arms.api.analysis.cost.model.vo.CostVO;
import com.arms.api.analysis.cost.model.vo.ReqCostVO;
import com.arms.api.analysis.cost.model.vo.ResolvedInfo;
import com.arms.api.analysis.cost.model.vo.SalaryVO;
import com.arms.api.analysis.cost.model.vo.TimeDiffVO;
import com.arms.api.analysis.cost.model.vo.VersionCostVO;
import com.arms.api.analysis.cost.model.vo.ZonedDateRange;
import com.arms.api.analysis.cost.service.AnalysisCost;
import com.arms.api.analysis.resource.model.vo.UniqueAssigneeVO;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.util.model.dto.PdServiceAndIsReqDTO;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.esquery.filter.RangeQueryFilter;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SearchDocDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SubGroupFieldDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.request.AggregationRequestDTO;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentAggregations;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentBucket;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentResultWrapper;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.DateUtils;
import org.springframework.stereotype.Service;

@Service
public class AnalysisCostImpl
implements AnalysisCost {
    private final DateTimeFormatter JIRA_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private final DateTimeFormatter ISO_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    private final EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper;

    @Override
    public List<CostVO> getAssigneeList(CostAggrDTO dto) {
        DocumentAggregations aggregations = this.esCommonRepositoryWrapper.aggregateRecentDocs(SimpleQuery.aggregation(AggregationRequestDTO.builder().mainField("pdServiceVersions").mainFieldAlias("pdServiceVersions").size(10000).addGroup(SubGroupFieldDTO.builder().subFieldAlias("assignees").subField("assignee.assignee_accountId.keyword").size(10000).isAscending(false).build(), SubGroupFieldDTO.builder().subFieldAlias("displayNames").subField("assignee.assignee_displayName.keyword").size(10000).build()).build()).andTermQueryMust("pdServiceId", dto.getPdServiceLink()).andTermsQueryFilter("pdServiceVersions", dto.getPdServiceVersionLinks()).andExistsQueryFilter("assignee"));
        List<DocumentBucket> subList = aggregations.deepestList();
        ArrayList<CostVO> costVOList = new ArrayList<CostVO>();
        for (DocumentBucket docBucket : subList) {
            String versionKey = docBucket.valueByName("pdServiceVersions");
            Long versionCount = docBucket.countByName("pdServiceVersions");
            String assigneeKey = docBucket.valueByName("assignees");
            Long assigneeCount = docBucket.countByName("assignees");
            String displayNameKey = docBucket.valueByName("displayNames");
            Long displayNameCount = docBucket.countByName("displayNames");
            CostVO costVO = CostVO.builder().versionKey(versionKey).versionCount(versionCount).assigneeKey(assigneeKey).assigneeCount(assigneeCount).displayNameKey(displayNameKey).displayNameCount(displayNameCount).build();
            costVOList.add(costVO);
        }
        return costVOList;
    }

    @Override
    public List<CostVO> getAssigneeListByProductVersionAndRequirement(CostAggrDTO dto) {
        PdServiceAndIsReqDTO pdServiceAndIsReq = dto.getPdServiceAndIsReq();
        boolean isReq = pdServiceAndIsReq.getIsReq();
        DocumentAggregations aggregations = this.esCommonRepositoryWrapper.aggregateRecentDocs(SimpleQuery.aggregation(AggregationRequestDTO.builder().mainField("pdServiceVersions").mainFieldAlias("pdServiceVersions").size(10000).addGroup(SubGroupFieldDTO.builder().subFieldAlias(isReq ? "requirement" : "parentRequirement").subField(isReq ? "key" : "parentReqKey").size(10000).build(), SubGroupFieldDTO.builder().subFieldAlias("assignees").subField("assignee.assignee_accountId.keyword").size(10000).isAscending(false).build(), SubGroupFieldDTO.builder().subFieldAlias("displayNames").subField("assignee.assignee_displayName.keyword").size(10000).build()).build()).andTermQueryMust("pdServiceId", dto.getPdServiceLink()).andTermQueryMust("isReq", isReq).andTermsQueryFilter("pdServiceVersions", dto.getPdServiceVersionLinks()).andExistsQueryFilter("assignee"));
        List<DocumentBucket> subList = aggregations.deepestList();
        ArrayList<CostVO> costVOList = new ArrayList<CostVO>();
        for (DocumentBucket docBucket : subList) {
            String versionKey = docBucket.valueByName("pdServiceVersions");
            Long versionCount = docBucket.countByName("pdServiceVersions");
            String reqKey = docBucket.valueByName("requirement");
            Long reqCount = docBucket.countByName("requirement");
            String subReqKey = docBucket.valueByName("parentRequirement");
            Long subReqCount = docBucket.countByName("parentRequirement");
            String assigneeKey = docBucket.valueByName("assignees");
            Long assigneeCount = docBucket.countByName("assignees");
            String displayNameKey = docBucket.valueByName("displayNames");
            Long displayNameCount = docBucket.countByName("displayNames");
            CostVO costVO = CostVO.builder().versionKey(versionKey).versionCount(versionCount).reqKey(reqKey).reqCount(reqCount).subReqKey(subReqKey).subReqCount(subReqCount).assigneeKey(assigneeKey).assigneeCount(assigneeCount).displayNameKey(displayNameKey).displayNameCount(displayNameCount).build();
            costVOList.add(costVO);
        }
        return costVOList;
    }

    @Override
    public List<CostVO> aggregationByAssigneeAccountId(CostAggrDTO dto) {
        DocumentAggregations aggregations = this.esCommonRepositoryWrapper.aggregateRecentDocs(SimpleQuery.aggregation(AggregationRequestDTO.builder().mainField("assignee.assignee_accountId.keyword").mainFieldAlias("accountId").size(10000).build()).andTermQueryMust("pdServiceId", dto.getPdServiceLink()).andTermsQueryFilter("pdServiceVersions", dto.getPdServiceVersionLinks()).andExistsQueryFilter("assignee"));
        List<DocumentBucket> documentBuckets = aggregations.docBuckets();
        ArrayList<CostVO> costVOList = new ArrayList<CostVO>();
        for (DocumentBucket documentBucket : documentBuckets) {
            costVOList.add(CostVO.builder().assigneeKey(documentBucket.valueByName("accountId")).assigneeCount(documentBucket.countByName("accountId")).build());
        }
        return costVOList;
    }

    @Override
    public List<CostVO> aggregationByReqLinkAndAssigneeAccountId(CostAggrDTO dto) {
        DocumentAggregations aggregations = this.esCommonRepositoryWrapper.aggregateRecentDocs(SimpleQuery.aggregation(AggregationRequestDTO.builder().mainField("cReqLink").mainFieldAlias("cReqLink").size(10000).addGroup(SubGroupFieldDTO.builder().subFieldAlias("assignees").subField("assignee.assignee_accountId.keyword").size(10000).isAscending(false).build()).build()).andTermQueryMust("pdServiceId", dto.getPdServiceLink()).andTermsQueryFilter("pdServiceVersions", dto.getPdServiceVersionLinks()).andTermQueryMust("isReq", dto.getIsReq()));
        List<DocumentBucket> documentBuckets = aggregations.deepestList();
        ArrayList<CostVO> costVOList = new ArrayList<CostVO>();
        for (DocumentBucket documentBucket : documentBuckets) {
            String cReqLinkKey = documentBucket.valueByName("cReqLink");
            Long cReqLinkCount = documentBucket.countByName("cReqLink");
            String assigneeKey = documentBucket.valueByName("assignees");
            Long assigneeCount = documentBucket.countByName("assignees");
            CostVO costVO = CostVO.builder().reqLinkKey(cReqLinkKey).reqLinkCount(cReqLinkCount).assigneeKey(assigneeKey).assigneeCount(assigneeCount).build();
            costVOList.add(costVO);
        }
        return costVOList;
    }

    private Map<String, Double> dailyCostMapByAccountId(List<SalaryVO> salaryList) {
        return salaryList.stream().collect(Collectors.toMap(SalaryVO::getC_key, salaryVO -> {
            String annualIncomeStr = salaryVO.getC_annual_income();
            if (annualIncomeStr == null || annualIncomeStr.isEmpty()) {
                return 0.0;
            }
            try {
                double annualIncome = Double.parseDouble(annualIncomeStr);
                if (annualIncome == 0.0) {
                    return 0.0;
                }
                return (double)Math.round(annualIncome / 365.0 * 100.0) / 100.0;
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }));
    }

    @Override
    public List<AssigneeTimeDiffVO> calculateWorkdayByAccountId(CostRequestDTO costRequestDTO) {
        Map<String, UniqueAssigneeVO> assigneeMap = this.uniqueAssigneeMap(costRequestDTO);
        List accountIdList = assigneeMap.keySet().stream().toList();
        ArrayList<AssigneeTimeDiffVO> result = new ArrayList<AssigneeTimeDiffVO>();
        for (String accountId : accountIdList) {
            TimeDiffVO timeDiff = this.getAlmIssueListByAccountId(costRequestDTO, accountId);
            UniqueAssigneeVO uniqueAssigneeVO = assigneeMap.get(accountId);
            result.add(AssigneeTimeDiffVO.builder().accountId(accountId).assigneeName(uniqueAssigneeVO.getName()).emailAddress(uniqueAssigneeVO.getEmailAddress()).daysDiff(timeDiff.getDaysDiff()).hoursDiff(timeDiff.getHoursDiff()).build());
        }
        return result;
    }

    private TimeDiffVO getAlmIssueListByAccountId(CostRequestDTO costRequestDTO, String accountId) {
        DocumentResultWrapper<AlmIssueEntity> hits = this.esCommonRepositoryWrapper.findRecentHits(this.simpleQueryForSearchIssueByAccountId(costRequestDTO, accountId, null));
        long totalDays = 0L;
        long totalHours = 0L;
        if (hits.getTotalHits() > 0L) {
            List<AlmIssueEntity> docs = hits.toDocs();
            ArrayList<ZonedDateRange> ranges = new ArrayList<ZonedDateRange>();
            for (AlmIssueEntity doc : docs) {
                ZonedDateTime start = this.parseDate(doc.stringValueOfCreatedDate()).toLocalDate().atStartOfDay(ZoneId.systemDefault());
                ZonedDateTime end = this.parseDate(doc.getResolutiondate()).toLocalDate().atStartOfDay(ZoneId.systemDefault());
                ranges.add(new ZonedDateRange(start, end));
            }
            List<ZonedDateRange> mergedRanges = this.mergeDateRanges(ranges);
            totalDays = mergedRanges.stream().mapToLong(r -> ChronoUnit.DAYS.between(r.getStart().toLocalDate(), r.getEnd().toLocalDate()) + 1L).sum();
            totalHours = mergedRanges.stream().mapToLong(r -> Duration.between(r.getStart(), r.getEnd()).toHours()).sum();
        }
        return TimeDiffVO.builder().daysDiff(totalDays).hoursDiff(totalHours).build();
    }

    private List<ZonedDateRange> mergeDateRanges(List<ZonedDateRange> ranges) {
        if (ranges.isEmpty()) {
            return Collections.emptyList();
        }
        ranges.sort(Comparator.comparing(ZonedDateRange::getStart));
        ArrayList<ZonedDateRange> merged = new ArrayList<ZonedDateRange>();
        ZonedDateRange prev = ranges.get(0);
        for (int i = 1; i < ranges.size(); ++i) {
            ZonedDateRange curr = ranges.get(i);
            if (!curr.getStart().isAfter(prev.getEnd().plusDays(1L))) {
                ZonedDateTime newEnd = prev.getEnd().isAfter(curr.getEnd()) ? prev.getEnd() : curr.getEnd();
                prev = new ZonedDateRange(prev.getStart(), newEnd);
                continue;
            }
            merged.add(prev);
            prev = curr;
        }
        merged.add(prev);
        return merged;
    }

    private SimpleQuery<SearchDocDTO> simpleQueryForSearchIssueByAccountId(CostRequestDTO costRequestDTO, String accountId, Boolean isReq) {
        PdServiceAndIsReqDTO pdServiceAndIsReq = costRequestDTO.getPdServiceAndIsReq();
        return SimpleQuery.termQueryMust("pdServiceId", pdServiceAndIsReq.getPdServiceId()).andTermsQueryFilter("pdServiceVersions", pdServiceAndIsReq.getPdServiceVersions()).andTermQueryMust("assignee.assignee_accountId.keyword", accountId).andTermQueryMust("isReq", isReq).andRangeQueryFilter(RangeQueryFilter.of("updated").betweenDate(costRequestDTO.getStartDate(), costRequestDTO.getEndDate())).andExistsQueryFilter("resolutiondate");
    }

    private Map<String, UniqueAssigneeVO> uniqueAssigneeMap(CostRequestDTO costRequestDTO) {
        PdServiceAndIsReqDTO pdServiceAndIsReq = costRequestDTO.getPdServiceAndIsReq();
        DocumentAggregations documentAggregations = this.esCommonRepositoryWrapper.aggregateRecentDocs(SimpleQuery.aggregation(AggregationRequestDTO.builder().mainField("assignee.assignee_accountId.keyword").mainFieldAlias("accountId").addGroup(SubGroupFieldDTO.builder().subFieldAlias("assigneeName").subField("assignee.assignee_displayName.keyword").build(), SubGroupFieldDTO.builder().subFieldAlias("assigneeEmail").subField("assignee.assignee_emailAddress.keyword").build()).build()).andTermQueryMust("pdServiceId", pdServiceAndIsReq.getPdServiceId()).andTermsQueryFilter("pdServiceVersions", pdServiceAndIsReq.getPdServiceVersions()).andTermQueryMust("isReq", null).andRangeQueryFilter(RangeQueryFilter.of("updated").betweenDate(costRequestDTO.getStartDate(), costRequestDTO.getEndDate())).andExistsQueryFilter("assignee").andTermsQueryFilter("assignee.assignee_accountId.keyword", costRequestDTO.getAccounts()));
        List<DocumentBucket> deepestList = documentAggregations.deepestList();
        HashMap<String, UniqueAssigneeVO> accountIdAssigneeMap = new HashMap<String, UniqueAssigneeVO>();
        for (DocumentBucket documentBucket : deepestList) {
            String accountId = documentBucket.valueByName("accountId");
            String name = documentBucket.valueByName("assigneeName");
            String email = documentBucket.valueByName("assigneeEmail");
            accountIdAssigneeMap.compute(accountId, (key, existingAssignee) -> {
                if (existingAssignee == null) {
                    return UniqueAssigneeVO.builder().accountId(accountId).name(name).emailAddress(Optional.ofNullable(email).orElse("")).build();
                }
                String updatedName = this.mergeNames(existingAssignee.getName(), name);
                String updatedEmail = this.mergeEmails(existingAssignee.getEmailAddress(), email);
                return UniqueAssigneeVO.builder().accountId(existingAssignee.getAccountId()).name(updatedName).emailAddress(updatedEmail).build();
            });
        }
        return accountIdAssigneeMap;
    }

    private String mergeNames(String existingName, String newName) {
        if (existingName == null || existingName.isEmpty()) {
            return newName;
        }
        if (newName == null || newName.isEmpty()) {
            return existingName;
        }
        if (existingName.contains(newName)) {
            return existingName;
        }
        return existingName + ", " + newName;
    }

    private String mergeEmails(String existingEmail, String newEmail) {
        if (existingEmail == null || existingEmail.isEmpty()) {
            return newEmail;
        }
        if (newEmail == null || newEmail.isEmpty()) {
            return existingEmail;
        }
        if (existingEmail.contains(newEmail)) {
            return existingEmail;
        }
        return existingEmail + ", " + newEmail;
    }

    private ZonedDateTime parseDate(String date) {
        DateTimeFormatter formatter = this.determineFormatter(date);
        return ZonedDateTime.parse(date, formatter);
    }

    public long calculateDifference(String created, String resolutionDate, String mode) {
        ZonedDateTime createdDate = this.parseDate(created);
        ZonedDateTime resolvedDate = this.parseDate(resolutionDate);
        long millisDiff = Duration.between(createdDate, resolvedDate).toMillis();
        long daysDiff = ChronoUnit.DAYS.between(createdDate.toLocalDate(), resolvedDate.toLocalDate());
        if ("millisDiff".equals(mode)) {
            return millisDiff;
        }
        return daysDiff + 1L;
    }

    private DateTimeFormatter determineFormatter(String date) {
        if (date.matches(".*[+-]\\d{4}$")) {
            return this.JIRA_FORMATTER;
        }
        return this.ISO_FORMATTER;
    }

    @Override
    public List<CostVO> calculationCost(CostDTO costDTO) {
        Map<String, AssigneeSalaryDTO> assigneeSalaryDTOMap = costDTO.getAccounts();
        List<AlmIssueEntity> relatedIssues = this.getRelatedIssues(costDTO);
        HashMap<Long, ReqCostVO> reqCostVOMap = new HashMap<Long, ReqCostVO>();
        HashMap<Long, VersionCostVO> versionCostVOMap = new HashMap<Long, VersionCostVO>();
        HashMap<String, AssigneePerformanceVO> assigneePerformanceVOMap = new HashMap<String, AssigneePerformanceVO>();
        ArrayList<CostVO> costVOList = new ArrayList<CostVO>();
        for (AlmIssueEntity almIssueEntity : relatedIssues) {
            Date created;
            Long armsReqCId;
            AlmIssueEntity.Assignee assignee = almIssueEntity.getAssignee();
            if (assignee == null) continue;
            String accountId = assignee.getAccountId();
            String displayName = assignee.getDisplayName();
            AssigneeSalaryDTO assigneeSalaryDTO = assigneeSalaryDTOMap.get(accountId);
            if (assigneeSalaryDTO == null || (armsReqCId = almIssueEntity.getCReqLink()) == null || armsReqCId <= 0L || (created = almIssueEntity.getCreated()) == null) continue;
            ResolvedInfo resolvedInfo = this.resolveResolutionDates(almIssueEntity);
            double priorityWeight = this.getPriorityWeight(almIssueEntity);
            long salary = Optional.ofNullable(assigneeSalaryDTO.getSalary()).orElse(0L);
            long roundedCost = this.calculateIssueCost(created, resolvedInfo.resolutionDate(), salary, priorityWeight);
            reqCostVOMap.compute(armsReqCId, (id, existing) -> {
                long newCost = (existing == null ? 0L : existing.getCost()) + roundedCost;
                return ReqCostVO.builder().requirementId(armsReqCId).requirementName(almIssueEntity.getSummary()).issueKey(almIssueEntity.getKey()).cost(newCost).build();
            });
            List<Long> pdServiceVersions = almIssueEntity.getLinkedIssuePdServiceVersions();
            for (Long versionId : pdServiceVersions) {
                VersionCostVO versionCostVO = (VersionCostVO)versionCostVOMap.get(versionId);
                versionCostVO = versionCostVO == null ? VersionCostVO.builder().versionId(versionId).cost(roundedCost).build() : VersionCostVO.builder().versionId(versionId).cost(versionCostVO.getCost() + roundedCost).build();
                versionCostVOMap.put(versionId, versionCostVO);
            }
            if (resolvedInfo.isResolved()) {
                AssigneePerformanceVO assigneePerformanceVO = (AssigneePerformanceVO)assigneePerformanceVOMap.get(accountId);
                assigneePerformanceVO = assigneePerformanceVO == null ? AssigneePerformanceVO.builder().assigneeId(accountId).performance(roundedCost).salary(salary).build() : AssigneePerformanceVO.builder().assigneeId(assigneePerformanceVO.getAssigneeId()).performance(assigneePerformanceVO.getPerformance() + roundedCost).salary(assigneePerformanceVO.getSalary()).build();
                assigneePerformanceVOMap.put(accountId, assigneePerformanceVO);
            }
            CostVO costVO = CostVO.builder().assigneeKey(accountId).displayNameKey(displayName).reqKey(almIssueEntity.getKey()).reqLinkKey(almIssueEntity.getCReqLink().toString()).versionKey(almIssueEntity.getLinkedIssuePdServiceVersions().toString()).build();
            costVOList.add(costVO);
        }
        return costVOList;
    }

    private List<AlmIssueEntity> getRelatedIssues(CostDTO costDTO) {
        PdServiceAndIsReqDTO pdServiceAndIsReq = costDTO.getPdServiceAndIsReq();
        Long pdServiceId = pdServiceAndIsReq.getPdServiceId();
        List<Long> pdServiceVersions = pdServiceAndIsReq.getPdServiceVersions();
        return this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termsQueryFilter("linkedIssuePdServiceIds", List.of(pdServiceId)).andTermsQueryFilter("linkedIssuePdServiceVersions", pdServiceVersions).andRangeQueryFilter(RangeQueryFilter.of("updated").betweenDate(costDTO.getStartDate(), costDTO.getEndDate()))).toDocs();
    }

    private long calculateIssueCost(Date createdDate, Date resolutionDate, long salary, double priorityWeight) {
        long cost = this.calculateCostByAssignee(createdDate, resolutionDate, salary);
        return (long)Math.ceil((double)cost * priorityWeight);
    }

    private long calculateCostByAssignee(Date createdDate, Date resolutionDate, long salary) {
        LocalDate start = createdDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate end = resolutionDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        long workdays = this.calculateWorkdays(start, end);
        long dailyPay = Math.round((double)salary / 365.0);
        return workdays * dailyPay;
    }

    private long calculateWorkdays(LocalDate start, LocalDate end) {
        long workdays = 1L;
        LocalDate current = start;
        while (!current.isAfter(end)) {
            if (current.getDayOfWeek() == DayOfWeek.SATURDAY || current.getDayOfWeek() != DayOfWeek.SUNDAY) {
                // empty if block
            }
            current = current.plusDays(1L);
        }
        return workdays;
    }

    private ResolvedInfo resolveResolutionDates(AlmIssueEntity issue) {
        String strResolved = issue.getResolutiondate();
        if (StringUtils.isEmpty((CharSequence)strResolved)) {
            return new ResolvedInfo(new Date(), false);
        }
        Date resolutionDate = DateUtils.parseDate((String)strResolved);
        return new ResolvedInfo(resolutionDate, true);
    }

    private double getPriorityWeight(AlmIssueEntity almIssueEntity) {
        AlmIssueEntity.CReqProperty cReqProperty = almIssueEntity.getCReqProperty();
        if (cReqProperty == null) {
            return 1.0;
        }
        Long armsReqPriorityId = cReqProperty.getCReqPriorityLink();
        String armsReqPriorityName = cReqProperty.getCReqPriorityName();
        return 1.0;
    }

    @Generated
    public AnalysisCostImpl(EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
    }
}

