/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.esframework.model.vo;

import com.arms.egovframework.javaservice.esframework.model.vo.SearchDocResult;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;

public class DocumentResultWrapper<T>
implements SearchDocResult {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentResultWrapper.class);
    private final SearchHits<T> searchHits;
    private final Class<T> clazz;
    private final Long totalHits;
    private final List<Object> lastSortValue;

    public DocumentResultWrapper(SearchHits<T> searchHits, Class<T> clazz) {
        this.totalHits = searchHits.getTotalHits();
        this.searchHits = searchHits;
        this.clazz = clazz;
        int hitsSize = searchHits.getSearchHits().size();
        int lastIndex = hitsSize - 1;
        this.lastSortValue = lastIndex > -1 ? ((SearchHit)searchHits.getSearchHits().get(lastIndex)).getSortValues() : new ArrayList();
    }

    public List<T> toDocs() {
        return this.searchHits.stream().map(SearchHit::getContent).collect(Collectors.toList());
    }

    public List<SearchHit<T>> toHitDocs() {
        return this.searchHits.getSearchHits();
    }

    public T findFirst() {
        return (T)this.getT(false);
    }

    private T getT(boolean warningVisible) {
        List searchHitsDocs = this.toHitDocs();
        if (warningVisible && searchHitsDocs.size() > 1) {
            log.warn("2\uac74 \uc774\uc0c1\uc774 \uc870\ud68c \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
        }
        return (T)searchHitsDocs.stream().filter(a -> a.getIndex() != null).sorted(Comparator.comparing(SearchHit::getIndex, Comparator.reverseOrder())).map(SearchHit::getContent).findFirst().orElseGet(() -> {
            try {
                return this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        });
    }

    public T fetchOnlyOne() {
        return (T)this.getT(true);
    }

    @Generated
    public Long getTotalHits() {
        return this.totalHits;
    }

    @Generated
    public List<Object> getLastSortValue() {
        return this.lastSortValue;
    }
}

