/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.report.service;

import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.report.model.AssigneeIssueCountVO;
import com.arms.api.report.model.FullDataRequestDTO;
import com.arms.api.report.model.FullDataResponseDTO;
import com.arms.api.report.model.\uc791\uc5c5\uc790_\uc815\ubcf4;
import com.arms.api.report.service.ReportService;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.esquery.filter.RangeQueryFilter;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SearchDocDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SubGroupFieldDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.request.AggregationRequestDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.request.SearchRequestDTO;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentAggregations;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentBucket;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentResultWrapper;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="\ub9ac\ud3ec\ud2b8_\uc11c\ube44\uc2a4")
public class ReportServiceImpl
implements ReportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportServiceImpl.class);
    private final EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper;
    private ServerInfoService serverInfoService;

    public List<\uc791\uc5c5\uc790_\uc815\ubcf4> \uc791\uc5c5\uc790_\ubaa9\ub85d_\uac00\uc838\uc624\uae30() {
        Map serverIdToTypeMap = this.serverInfoService.getServerIdToTypeMap();
        DocumentAggregations documentAggregations = this.esCommonRepositoryWrapper.aggregateRecentDocs(SimpleQuery.aggregation((AggregationRequestDTO)AggregationRequestDTO.builder().mainField("assignee.assignee_emailAddress.keyword").mainFieldAlias("assignee").addGroup(new SubGroupFieldDTO[]{SubGroupFieldDTO.builder().subFieldAlias("jiraServerId").subField("jira_server_id").build(), SubGroupFieldDTO.builder().subFieldAlias("displayName").subField("assignee.assignee_displayName.keyword").build(), SubGroupFieldDTO.builder().subFieldAlias("accountId").subField("assignee.assignee_accountId.keyword").build()}).build()).andExistsQueryFilter("assignee"));
        List deepestList = documentAggregations.deepestList();
        HashSet<\uc791\uc5c5\uc790_\uc815\ubcf4> \uc791\uc5c5\uc790_\ubaa9\ub85d = new HashSet<\uc791\uc5c5\uc790_\uc815\ubcf4>();
        if (documentAggregations.getTotalHits() == 0L) {
            log.info("[ \ub9ac\ud3ec\ud2b8_\uc11c\ube44\uc2a4_\ud504\ub85c\uc138\uc2a4 :: \uc791\uc5c5\uc790_\ubaa9\ub85d_\uac00\uc838\uc624\uae30 ] :: \uc791\uc5c5\uc790 \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4. \uc0ac\uc774\uc988 => 0");
        } else {
            for (DocumentBucket documentBucket : deepestList) {
                \uc791\uc5c5\uc790_\uc815\ubcf4 \uc791\uc5c5\uc790 = new \uc791\uc5c5\uc790_\uc815\ubcf4();
                \uc791\uc5c5\uc790.setEmailAddress(documentBucket.valueByName("emailAddress"));
                \uc791\uc5c5\uc790.setServerType((String)serverIdToTypeMap.get(documentBucket.valueByName("jiraServerId")));
                \uc791\uc5c5\uc790.setDisplayName(documentBucket.valueByName("displayName"));
                \uc791\uc5c5\uc790.setAccountId(documentBucket.valueByName("accountId"));
                \uc791\uc5c5\uc790_\ubaa9\ub85d.add(\uc791\uc5c5\uc790);
            }
        }
        if (\uc791\uc5c5\uc790_\ubaa9\ub85d.isEmpty()) {
            return new ArrayList<\uc791\uc5c5\uc790_\uc815\ubcf4>(Collections.emptyList());
        }
        return new ArrayList<\uc791\uc5c5\uc790_\uc815\ubcf4>(\uc791\uc5c5\uc790_\ubaa9\ub85d);
    }

    private SimpleQuery<SearchDocDTO> \ube4c\ub354\uc5d0_\ub123\uc744_\uacf5\ud1b5_\ucffc\ub9ac_\ubaa9\ub85d_\uc138\ud305(SimpleQuery<SearchDocDTO> simpleQuery, FullDataRequestDTO fullDataRequestDTO) {
        if (fullDataRequestDTO.getPdServiceId() != null) {
            simpleQuery.andTermQueryFilter("pdServiceId", (Object)fullDataRequestDTO.getPdServiceId());
        }
        if (fullDataRequestDTO.getPdServiceVersionIds() != null && !fullDataRequestDTO.getPdServiceVersionIds().isEmpty()) {
            simpleQuery.andTermsQueryFilter("pdServiceVersions", fullDataRequestDTO.getPdServiceVersionIds());
        }
        if (fullDataRequestDTO.getAlmProjectUrls() != null && !fullDataRequestDTO.getAlmProjectUrls().isEmpty()) {
            simpleQuery.andTermsQueryFilter("project.project_self.keyword", fullDataRequestDTO.getAlmProjectUrls());
        }
        if (fullDataRequestDTO.getEmailAddress() != null && !fullDataRequestDTO.getEmailAddress().isEmpty()) {
            simpleQuery.andTermsQueryFilter("assignee.assignee_emailAddress.keyword", fullDataRequestDTO.getEmailAddress());
        }
        if (fullDataRequestDTO.getStartDate() != null && fullDataRequestDTO.getEndDate() == null) {
            simpleQuery.andRangeQueryFilter(RangeQueryFilter.of((String)"updated").gte(fullDataRequestDTO.getStartDate()));
        } else if (fullDataRequestDTO.getStartDate() == null && fullDataRequestDTO.getEndDate() != null) {
            simpleQuery.andRangeQueryFilter(RangeQueryFilter.of((String)"updated").lte(fullDataRequestDTO.getStartDate()));
        } else if (fullDataRequestDTO.getStartDate() != null && fullDataRequestDTO.getEndDate() != null) {
            simpleQuery.andRangeQueryFilter(RangeQueryFilter.of((String)"updated").betweenDate(fullDataRequestDTO.getStartDate(), fullDataRequestDTO.getEndDate()));
        }
        return simpleQuery;
    }

    public FullDataResponseDTO \uc774\uc288_\ubaa9\ub85d_\uac00\uc838\uc624\uae30_\uc2a4\ud06c\ub864API(FullDataRequestDTO fullDataRequestDTO) {
        SearchRequestDTO searchRequestDTO = new SearchRequestDTO();
        searchRequestDTO.setPage(fullDataRequestDTO.getPage());
        searchRequestDTO.setSize(fullDataRequestDTO.getSize());
        List \uc2a4\ud06c\ub864API_\ud65c\uc6a9_\uc774\uc288_\ubaa9\ub85d = this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.search((SearchRequestDTO)searchRequestDTO).andTermQueryFilter("pdServiceId", (Object)fullDataRequestDTO.getPdServiceId()).andTermsQueryFilter("pdServiceVersions", fullDataRequestDTO.getPdServiceVersionIds()).andTermsQueryFilter("project.project_self.keyword", fullDataRequestDTO.getAlmProjectUrls()).andTermsQueryFilter("assignee.assignee_emailAddress.keyword", fullDataRequestDTO.getEmailAddress()).andRangeQueryFilter(RangeQueryFilter.of((String)"updated").betweenDate(fullDataRequestDTO.getStartDate(), fullDataRequestDTO.getEndDate()))).toDocs();
        FullDataResponseDTO \uacb0\uacfc = new FullDataResponseDTO();
        \uacb0\uacfc.setTotalHits(Long.valueOf(\uc2a4\ud06c\ub864API_\ud65c\uc6a9_\uc774\uc288_\ubaa9\ub85d.size()));
        \uacb0\uacfc.setIssueEntityList(\uc2a4\ud06c\ub864API_\ud65c\uc6a9_\uc774\uc288_\ubaa9\ub85d);
        return \uacb0\uacfc;
    }

    public FullDataResponseDTO \uc774\uc288_\ubaa9\ub85d_\uac00\uc838\uc624\uae30(FullDataRequestDTO fullDataRequestDTO) {
        ArrayList \ubaa8\ub4e0_\uc774\uc288_\ubaa9\ub85d = new ArrayList();
        ArrayList<AlmIssueEntity> ALM_\uc0dd\uc131_\uc5f0\uacb0\uc774\uc288 = new ArrayList<AlmIssueEntity>();
        ArrayList<AlmIssueEntity> \ud558\uc704\uc774\uc288_\ubaa9\ub85d = new ArrayList<AlmIssueEntity>();
        List \ud558\uc704\uc774\uc288\ub9cc_\uc874\uc7ac\ud558\ub294_\uc774\uc288\uc758_\uc694\uad6c\uc0ac\ud56d\uc774\uc288_\ubaa9\ub85d = new ArrayList();
        HashSet<String> \ud558\uc704\uc774\uc288_\uc5f0\uacb0\uc774\uc288_docIdSet = new HashSet<String>();
        HashSet<String> linkedIssuesDocIdSet = new HashSet<String>();
        SearchRequestDTO searchRequestDTO = new SearchRequestDTO();
        searchRequestDTO.setPage(fullDataRequestDTO.getPage());
        searchRequestDTO.setSize(fullDataRequestDTO.getSize());
        SimpleQuery \uc694\uad6c\uc0ac\ud56d_\ucffc\ub9ac_\ubaa9\ub85d = this.\ube4c\ub354\uc5d0_\ub123\uc744_\uacf5\ud1b5_\ucffc\ub9ac_\ubaa9\ub85d_\uc138\ud305(SimpleQuery.search((SearchRequestDTO)searchRequestDTO), fullDataRequestDTO);
        \uc694\uad6c\uc0ac\ud56d_\ucffc\ub9ac_\ubaa9\ub85d.andTermQueryMust("isReq", (Object)true);
        List \uc694\uad6c\uc0ac\ud56d_\ubaa9\ub85d = this.esCommonRepositoryWrapper.findRecentDocsByScrollApi(\uc694\uad6c\uc0ac\ud56d_\ucffc\ub9ac_\ubaa9\ub85d);
        SimpleQuery \ud558\uc704\uc774\uc288_ALM\uc9c1\uc811\uc5f0\uacb0\uc774\uc288_\ucffc\ub9ac_\ubaa9\ub85d = this.\ube4c\ub354\uc5d0_\ub123\uc744_\uacf5\ud1b5_\ucffc\ub9ac_\ubaa9\ub85d_\uc138\ud305(SimpleQuery.search((SearchRequestDTO)searchRequestDTO), fullDataRequestDTO);
        \ud558\uc704\uc774\uc288_ALM\uc9c1\uc811\uc5f0\uacb0\uc774\uc288_\ucffc\ub9ac_\ubaa9\ub85d.andTermQueryMust("isReq", (Object)false);
        List \ud558\uc704\uc774\uc288_ALM\uc9c1\uc811\uc5f0\uacb0\uc774\uc288_\ubaa9\ub85d = this.esCommonRepositoryWrapper.findRecentDocsByScrollApi(\ud558\uc704\uc774\uc288_ALM\uc9c1\uc811\uc5f0\uacb0\uc774\uc288_\ucffc\ub9ac_\ubaa9\ub85d);
        for (AlmIssueEntity entity : \ud558\uc704\uc774\uc288_ALM\uc9c1\uc811\uc5f0\uacb0\uc774\uc288_\ubaa9\ub85d) {
            String upperKey = entity.getUpperKey();
            \ud558\uc704\uc774\uc288_\uc5f0\uacb0\uc774\uc288_docIdSet.add(entity.getRecentId());
            if (upperKey == null || upperKey.isEmpty()) {
                ALM_\uc0dd\uc131_\uc5f0\uacb0\uc774\uc288.add(entity);
                continue;
            }
            \ud558\uc704\uc774\uc288_\ubaa9\ub85d.add(entity);
        }
        Set parentReqKeySet = \uc694\uad6c\uc0ac\ud56d_\ubaa9\ub85d.stream().map(AlmIssueEntity::getKey).collect(Collectors.toSet());
        ArrayList \uc911\ubcf5\uc81c\uac70\ud55c_\ud558\uc704\uc774\uc288\uc758_\ubd80\ubaa8\ud0a4 = new ArrayList(\ud558\uc704\uc774\uc288_\ubaa9\ub85d.stream().map(AlmIssueEntity::getParentReqKey).collect(Collectors.toSet()));
        List \ud558\uc704\uc774\uc288\ub9cc_\uc874\uc7ac\ud558\ub294\uacbd\uc6b0\uc758_\ubd80\ubaa8\ud0a4 = \uc911\ubcf5\uc81c\uac70\ud55c_\ud558\uc704\uc774\uc288\uc758_\ubd80\ubaa8\ud0a4.stream().filter(Objects::nonNull).filter(key -> !parentReqKeySet.contains(key)).collect(Collectors.toList());
        if (!\ud558\uc704\uc774\uc288\ub9cc_\uc874\uc7ac\ud558\ub294\uacbd\uc6b0\uc758_\ubd80\ubaa8\ud0a4.isEmpty()) {
            \ud558\uc704\uc774\uc288\ub9cc_\uc874\uc7ac\ud558\ub294_\uc774\uc288\uc758_\uc694\uad6c\uc0ac\ud56d\uc774\uc288_\ubaa9\ub85d = this.esCommonRepositoryWrapper.findRecentDocsByScrollApi(SimpleQuery.termQueryMust((String)"isReq", (Object)true).andTermsQueryFilter("key", \ud558\uc704\uc774\uc288\ub9cc_\uc874\uc7ac\ud558\ub294\uacbd\uc6b0\uc758_\ubd80\ubaa8\ud0a4));
        } else {
            log.info("\ud558\uc704\uc774\uc288\ub9cc \uc874\uc7ac\ud558\ub294 \uacbd\uc6b0 \uc5c6\uc74c.");
        }
        for (AlmIssueEntity entity : \uc694\uad6c\uc0ac\ud56d_\ubaa9\ub85d) {
            List linkedIssues = entity.getLinkedIssues();
            if (linkedIssues == null || linkedIssues.isEmpty()) continue;
            for (String docId : linkedIssues) {
                linkedIssuesDocIdSet.add(docId);
            }
        }
        linkedIssuesDocIdSet.removeAll(\ud558\uc704\uc774\uc288_\uc5f0\uacb0\uc774\uc288_docIdSet);
        ArrayList linkedIssuesDocIdList = new ArrayList(linkedIssuesDocIdSet);
        List \uc694\uad6c\uc0ac\ud56d_\uc5f0\uacb0\uc774\uc288_\ubaa9\ub85d = this.esCommonRepositoryWrapper.findRecentDocsByScrollApi(SimpleQuery.termQueryMust((String)"recent_id", linkedIssuesDocIdList).andTermQueryMust("isReq", (Object)false));
        \ubaa8\ub4e0_\uc774\uc288_\ubaa9\ub85d.addAll(\uc694\uad6c\uc0ac\ud56d_\ubaa9\ub85d);
        if (!\ud558\uc704\uc774\uc288\ub9cc_\uc874\uc7ac\ud558\ub294_\uc774\uc288\uc758_\uc694\uad6c\uc0ac\ud56d\uc774\uc288_\ubaa9\ub85d.isEmpty()) {
            \ubaa8\ub4e0_\uc774\uc288_\ubaa9\ub85d.addAll(\ud558\uc704\uc774\uc288\ub9cc_\uc874\uc7ac\ud558\ub294_\uc774\uc288\uc758_\uc694\uad6c\uc0ac\ud56d\uc774\uc288_\ubaa9\ub85d);
        }
        \ubaa8\ub4e0_\uc774\uc288_\ubaa9\ub85d.addAll(\ud558\uc704\uc774\uc288_\ubaa9\ub85d);
        \ubaa8\ub4e0_\uc774\uc288_\ubaa9\ub85d.addAll(ALM_\uc0dd\uc131_\uc5f0\uacb0\uc774\uc288);
        if (!\uc694\uad6c\uc0ac\ud56d_\uc5f0\uacb0\uc774\uc288_\ubaa9\ub85d.isEmpty()) {
            \ubaa8\ub4e0_\uc774\uc288_\ubaa9\ub85d.addAll(\uc694\uad6c\uc0ac\ud56d_\uc5f0\uacb0\uc774\uc288_\ubaa9\ub85d);
        }
        log.info("[\ub9ac\ud3ec\ud2b8_\uc11c\ube44\uc2a4_\ud504\ub85c\uc138\uc2a4 :: \uc774\uc288_\ubaa9\ub85d_\uac00\uc838\uc624\uae302 ] :: \uc694\uad6c\uc0ac\ud56d \uc774\uc288 \ucd1d \uac2f\uc218 => {}", (Object)(\uc694\uad6c\uc0ac\ud56d_\ubaa9\ub85d.size() + \ud558\uc704\uc774\uc288\ub9cc_\uc874\uc7ac\ud558\ub294_\uc774\uc288\uc758_\uc694\uad6c\uc0ac\ud56d\uc774\uc288_\ubaa9\ub85d.size()));
        FullDataResponseDTO \uacb0\uacfc = new FullDataResponseDTO();
        \uacb0\uacfc.setTotalHits(Long.valueOf(\ubaa8\ub4e0_\uc774\uc288_\ubaa9\ub85d.size()));
        \uacb0\uacfc.setIssueEntityList(\ubaa8\ub4e0_\uc774\uc288_\ubaa9\ub85d);
        log.info("[\ub9ac\ud3ec\ud2b8_\uc11c\ube44\uc2a4_\ud504\ub85c\uc138\uc2a4 :: \uc774\uc288_\ubaa9\ub85d_\uac00\uc838\uc624\uae302 ] :: \uc774\uc288 \ucd1d \uac2f\uc218 => {}", (Object)\ubaa8\ub4e0_\uc774\uc288_\ubaa9\ub85d.size());
        return \uacb0\uacfc;
    }

    public FullDataResponseDTO \uc774\uc288_\ubaa9\ub85d_\uac00\uc838\uc624\uae30_calendar(FullDataRequestDTO fullDataRequestDTO) {
        ArrayList \ubaa8\ub4e0_\uc774\uc288_\ubaa9\ub85d = new ArrayList();
        ArrayList<AlmIssueEntity> ALM_\uc0dd\uc131_\uc5f0\uacb0\uc774\uc288 = new ArrayList<AlmIssueEntity>();
        ArrayList<AlmIssueEntity> \ud558\uc704\uc774\uc288_\ubaa9\ub85d = new ArrayList<AlmIssueEntity>();
        List \ud558\uc704\uc774\uc288\ub9cc_\uc874\uc7ac\ud558\ub294_\uc774\uc288\uc758_\uc694\uad6c\uc0ac\ud56d\uc774\uc288_\ubaa9\ub85d = new ArrayList();
        HashSet<String> \ud558\uc704\uc774\uc288_\uc5f0\uacb0\uc774\uc288_docIdSet = new HashSet<String>();
        HashSet<String> linkedIssuesDocIdSet = new HashSet<String>();
        SearchRequestDTO searchRequestDTO = new SearchRequestDTO();
        searchRequestDTO.setPage(fullDataRequestDTO.getPage());
        searchRequestDTO.setSize(fullDataRequestDTO.getSize());
        SimpleQuery \uacf5\ud1b5_\ucffc\ub9ac_\ubaa9\ub85d = this.\ube4c\ub354\uc5d0_\ub123\uc744_\uacf5\ud1b5_\ucffc\ub9ac_\ubaa9\ub85d_\uc138\ud305(SimpleQuery.search((SearchRequestDTO)searchRequestDTO), fullDataRequestDTO);
        \uacf5\ud1b5_\ucffc\ub9ac_\ubaa9\ub85d.andTermQueryMust("isReq", (Object)true);
        DocumentResultWrapper docsBySearchAfter = this.esCommonRepositoryWrapper.findDocsBySearchAfter(\uacf5\ud1b5_\ucffc\ub9ac_\ubaa9\ub85d);
        List \uc694\uad6c\uc0ac\ud56d_\ubaa9\ub85d = docsBySearchAfter.toDocs();
        SimpleQuery \ud558\uc704\uc774\uc288_ALM\uc9c1\uc811\uc5f0\uacb0\uc774\uc288_\ucffc\ub9ac_\ubaa9\ub85d = this.\ube4c\ub354\uc5d0_\ub123\uc744_\uacf5\ud1b5_\ucffc\ub9ac_\ubaa9\ub85d_\uc138\ud305(SimpleQuery.search((SearchRequestDTO)searchRequestDTO), fullDataRequestDTO);
        \ud558\uc704\uc774\uc288_ALM\uc9c1\uc811\uc5f0\uacb0\uc774\uc288_\ucffc\ub9ac_\ubaa9\ub85d.andTermQueryMust("isReq", (Object)false);
        List \ud558\uc704\uc774\uc288_ALM\uc9c1\uc811\uc5f0\uacb0\uc774\uc288_\ubaa9\ub85d = this.esCommonRepositoryWrapper.findDocsBySearchAfter(\ud558\uc704\uc774\uc288_ALM\uc9c1\uc811\uc5f0\uacb0\uc774\uc288_\ucffc\ub9ac_\ubaa9\ub85d).toDocs();
        for (AlmIssueEntity entity : \ud558\uc704\uc774\uc288_ALM\uc9c1\uc811\uc5f0\uacb0\uc774\uc288_\ubaa9\ub85d) {
            String upperKey = entity.getUpperKey();
            \ud558\uc704\uc774\uc288_\uc5f0\uacb0\uc774\uc288_docIdSet.add(entity.getRecentId());
            if (upperKey == null || upperKey.isEmpty()) {
                ALM_\uc0dd\uc131_\uc5f0\uacb0\uc774\uc288.add(entity);
                continue;
            }
            \ud558\uc704\uc774\uc288_\ubaa9\ub85d.add(entity);
        }
        Set parentReqKeySet = \uc694\uad6c\uc0ac\ud56d_\ubaa9\ub85d.stream().map(AlmIssueEntity::getKey).collect(Collectors.toSet());
        ArrayList \uc911\ubcf5\uc81c\uac70\ud55c_\ud558\uc704\uc774\uc288\uc758_\ubd80\ubaa8\ud0a4 = new ArrayList(\ud558\uc704\uc774\uc288_\ubaa9\ub85d.stream().map(AlmIssueEntity::getParentReqKey).collect(Collectors.toSet()));
        List \ud558\uc704\uc774\uc288\ub9cc_\uc874\uc7ac\ud558\ub294\uacbd\uc6b0\uc758_\ubd80\ubaa8\ud0a4 = \uc911\ubcf5\uc81c\uac70\ud55c_\ud558\uc704\uc774\uc288\uc758_\ubd80\ubaa8\ud0a4.stream().filter(Objects::nonNull).filter(key -> !parentReqKeySet.contains(key)).collect(Collectors.toList());
        if (!\ud558\uc704\uc774\uc288\ub9cc_\uc874\uc7ac\ud558\ub294\uacbd\uc6b0\uc758_\ubd80\ubaa8\ud0a4.isEmpty()) {
            \ud558\uc704\uc774\uc288\ub9cc_\uc874\uc7ac\ud558\ub294_\uc774\uc288\uc758_\uc694\uad6c\uc0ac\ud56d\uc774\uc288_\ubaa9\ub85d = this.esCommonRepositoryWrapper.findDocsBySearchAfter(SimpleQuery.termQueryMust((String)"isReq", (Object)true).andTermsQueryFilter("key", \ud558\uc704\uc774\uc288\ub9cc_\uc874\uc7ac\ud558\ub294\uacbd\uc6b0\uc758_\ubd80\ubaa8\ud0a4)).toDocs();
        } else {
            log.info("\ud558\uc704\uc774\uc288\ub9cc \uc874\uc7ac\ud558\ub294 \uacbd\uc6b0 \uc5c6\uc74c.");
        }
        for (AlmIssueEntity entity : \uc694\uad6c\uc0ac\ud56d_\ubaa9\ub85d) {
            List linkedIssues = entity.getLinkedIssues();
            if (linkedIssues == null || linkedIssues.isEmpty()) continue;
            for (String docId : linkedIssues) {
                linkedIssuesDocIdSet.add(docId);
            }
        }
        linkedIssuesDocIdSet.removeAll(\ud558\uc704\uc774\uc288_\uc5f0\uacb0\uc774\uc288_docIdSet);
        ArrayList linkedIssuesDocIdList = new ArrayList(linkedIssuesDocIdSet);
        List \uc694\uad6c\uc0ac\ud56d_\uc5f0\uacb0\uc774\uc288_\ubaa9\ub85d = this.esCommonRepositoryWrapper.findDocsByScrollApi(SimpleQuery.search((SearchRequestDTO)searchRequestDTO).andTermsQueryFilter("recent_id", linkedIssuesDocIdList).andTermQueryMust("isReq", (Object)false));
        \ubaa8\ub4e0_\uc774\uc288_\ubaa9\ub85d.addAll(\uc694\uad6c\uc0ac\ud56d_\ubaa9\ub85d);
        if (!\ud558\uc704\uc774\uc288\ub9cc_\uc874\uc7ac\ud558\ub294_\uc774\uc288\uc758_\uc694\uad6c\uc0ac\ud56d\uc774\uc288_\ubaa9\ub85d.isEmpty()) {
            \ubaa8\ub4e0_\uc774\uc288_\ubaa9\ub85d.addAll(\ud558\uc704\uc774\uc288\ub9cc_\uc874\uc7ac\ud558\ub294_\uc774\uc288\uc758_\uc694\uad6c\uc0ac\ud56d\uc774\uc288_\ubaa9\ub85d);
        }
        \ubaa8\ub4e0_\uc774\uc288_\ubaa9\ub85d.addAll(\ud558\uc704\uc774\uc288_\ubaa9\ub85d);
        \ubaa8\ub4e0_\uc774\uc288_\ubaa9\ub85d.addAll(ALM_\uc0dd\uc131_\uc5f0\uacb0\uc774\uc288);
        if (!\uc694\uad6c\uc0ac\ud56d_\uc5f0\uacb0\uc774\uc288_\ubaa9\ub85d.isEmpty()) {
            \ubaa8\ub4e0_\uc774\uc288_\ubaa9\ub85d.addAll(\uc694\uad6c\uc0ac\ud56d_\uc5f0\uacb0\uc774\uc288_\ubaa9\ub85d);
        }
        log.info("[\ub9ac\ud3ec\ud2b8_\uc11c\ube44\uc2a4_\ud504\ub85c\uc138\uc2a4 :: \uc774\uc288_\ubaa9\ub85d_\uac00\uc838\uc624\uae302 ] :: \uc694\uad6c\uc0ac\ud56d \uc774\uc288 \ucd1d \uac2f\uc218 => {}", (Object)(\uc694\uad6c\uc0ac\ud56d_\ubaa9\ub85d.size() + \ud558\uc704\uc774\uc288\ub9cc_\uc874\uc7ac\ud558\ub294_\uc774\uc288\uc758_\uc694\uad6c\uc0ac\ud56d\uc774\uc288_\ubaa9\ub85d.size()));
        log.info("[\ub9ac\ud3ec\ud2b8_\uc11c\ube44\uc2a4_\ud504\ub85c\uc138\uc2a4 :: \uc774\uc288_\ubaa9\ub85d_\uac00\uc838\uc624\uae302 ] :: \uc774\uc288 \ucd1d \uac2f\uc218 => {}", (Object)\ubaa8\ub4e0_\uc774\uc288_\ubaa9\ub85d.size());
        ArrayList issues = \ubaa8\ub4e0_\uc774\uc288_\ubaa9\ub85d;
        Map uniqueIssues = issues.stream().collect(Collectors.toMap(issue -> issue.getKey() + "::" + String.valueOf(issue.getUpdated()), Function.identity(), (existing, newer) -> newer, LinkedHashMap::new));
        ArrayList distinctIssues = new ArrayList(uniqueIssues.values());
        FullDataResponseDTO \uacb0\uacfc = new FullDataResponseDTO();
        \uacb0\uacfc.setTotalHits(Long.valueOf(distinctIssues.size()));
        \uacb0\uacfc.setIssueEntityList(distinctIssues);
        log.info("[\ub9ac\ud3ec\ud2b8_\uc11c\ube44\uc2a4_\ud504\ub85c\uc138\uc2a4 :: \uc774\uc288_\ubaa9\ub85d_\uac00\uc838\uc624\uae302 ] :: \uc5d4\uc9c4 \uc774\uc288 \uc911\ubcf5\uc81c\uac70 \uac2f\uc218 => {}", (Object)distinctIssues.size());
        return \uacb0\uacfc;
    }

    public FullDataResponseDTO getReqIssueList(FullDataRequestDTO fullDataRequestDTO) {
        SearchRequestDTO searchRequestDTO = new SearchRequestDTO();
        searchRequestDTO.setPage(fullDataRequestDTO.getPage());
        searchRequestDTO.setSize(fullDataRequestDTO.getSize());
        SimpleQuery simpleQuery = this.\ube4c\ub354\uc5d0_\ub123\uc744_\uacf5\ud1b5_\ucffc\ub9ac_\ubaa9\ub85d_\uc138\ud305(SimpleQuery.search((SearchRequestDTO)searchRequestDTO), fullDataRequestDTO);
        simpleQuery.andTermsQueryFilter("pdServiceVersionIds", fullDataRequestDTO.getPdServiceVersionIds()).andTermQueryMust("isReq", (Object)true);
        List reqList = this.esCommonRepositoryWrapper.findRecentDocsByScrollApi(simpleQuery);
        FullDataResponseDTO result = new FullDataResponseDTO();
        result.setTotalHits(Long.valueOf(reqList.size()));
        result.setIssueEntityList(reqList);
        return result;
    }

    public AssigneeIssueCountVO getAssigneeAggregationList(FullDataRequestDTO fullDataRequestDTO) {
        DocumentAggregations documentAggregations = this.esCommonRepositoryWrapper.aggregateRecentDocs(SimpleQuery.aggregation((AggregationRequestDTO)AggregationRequestDTO.builder().mainField("assignee.assignee_emailAddress.keyword").mainFieldAlias("assigneeEmail").size(fullDataRequestDTO.getSize()).build()).andTermsQueryFilter("pdServiceId", fullDataRequestDTO.getPdServiceIds()).andTermsQueryFilter("pdServiceVersions", fullDataRequestDTO.getPdServiceVersionIds()).andExistsQueryFilter("assignee"));
        List documentBuckets = documentAggregations.deepestList();
        long totalIssueCount = documentAggregations.getTotalHits();
        long totalAssigneeCount = documentBuckets.size();
        HashMap<String, Long> assigneeCounts = new HashMap<String, Long>();
        for (DocumentBucket documentBucket : documentBuckets) {
            assigneeCounts.put(documentBucket.valueByName("assigneeEmail"), documentBucket.countByName("assigneeEmail"));
        }
        double avgIssuesPerAssignee = totalAssigneeCount > 0L ? (double)totalIssueCount / (double)totalAssigneeCount : 0.0;
        long maxIssues = assigneeCounts.values().stream().mapToLong(Long::longValue).max().orElse(0L);
        long minIssues = assigneeCounts.values().stream().mapToLong(Long::longValue).min().orElse(0L);
        return new AssigneeIssueCountVO(totalIssueCount, totalAssigneeCount, avgIssuesPerAssignee, maxIssues, minIssues, assigneeCounts);
    }

    @Generated
    public ReportServiceImpl(EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper, ServerInfoService serverInfoService) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
        this.serverInfoService = serverInfoService;
    }
}

