package com.arms.egovframework.javaservice.gcframework.model;

import lombok.Getter;

@Getter
public enum RepoType {

    GITEA("gitea"),
    GITHUB("github");

    private String value;

    RepoType(String value) {
        this.value = value;
    }

    /**
     * 문자열 값으로부터 RepoType Enum 상수를 찾는 정적 팩토리 메서드.
     * @param value 찾을 문자열 값
     * @return 해당 RepoType Enum 상수
     * @throws IllegalArgumentException 유효하지 않은 값일 경우
     */
    public static RepoType fromValue(String value) {
        for (RepoType type : RepoType.values()) {
            if (type.value.equalsIgnoreCase(value)) { // 대소문자 무시하고 비교
                return type;
            }
        }
        throw new IllegalArgumentException("Unknown RepoType value: " + value);
    }
}
