package com.arms.config;
//
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;

import java.util.HashSet;
import java.util.Set;


///**
// * Swagger 설정 클래스
// * Springfox 3.0.0 버전에 맞게 구성됨
// */
@Configuration
public class Swagger2Config {

    @Value("${springfox.documentation.swagger.v2.path:/global-config-api}")
    private String swaggerPath;

    @Bean
    public Docket api() {
        return new Docket(DocumentationType.SWAGGER_2)
            .useDefaultResponseMessages(false)
            .consumes(getConsumeContentTypes())
            .produces(getProduceContentTypes())
            .apiInfo(apiInfo())
            .select()
            .apis(RequestHandlerSelectors.basePackage("com.arms"))
            .paths(PathSelectors.any())
            .build()
            .genericModelSubstitutes(Mono.class, Flux.class)
            .pathMapping(swaggerPath)
            ;
    }

    private Set<String> getConsumeContentTypes() {
        Set<String> consumeContentTypes = new HashSet<>();

        consumeContentTypes.add("application/json;charset=UTF-8");
        consumeContentTypes.add("application/x-www-form-urlencoded");

        return consumeContentTypes;
    }

    private Set<String> getProduceContentTypes() {
        Set<String> produceContentTypes = new HashSet<>();

        produceContentTypes.add("application/json;charset=UTF-8");

        return produceContentTypes;
    }

    /**
     * API 정보 설정
     * @return API 정보 객체
     */
    private ApiInfo apiInfo() {
        return new ApiInfoBuilder()
            .title("Java Service Tree Framework Global Config API")
            .description("자바 서비스 트리 프레임워크의 글로벌 설정 API 문서입니다.")
            .version("1.0.0")
            .contact(new Contact("ARMS 개발팀", "http://www.313.co.kr", "313@313.co.kr"))
            .license("Apache License Version 2.0")
            .licenseUrl("http://www.apache.org/licenses/LICENSE-2.0")
            .build();
    }

}
