package com.arms.egovframework.javaservice.esframework.model.vo;

import com.arms.egovframework.javaservice.esframework.model.entity.IndexStatusEntity;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@NoArgsConstructor
@Getter
@Setter
public class CatIndexVO {

    private String health;

    private String status;

    private String index;

    private String uuid;

    private Integer pri;

    private Integer rep;

    @JsonProperty("docs.count")
    private Long docsCount;

    @JsonProperty("docs.deleted")
    private Long docDeleted;

    @JsonProperty("store.size")
    private String storeSize;

    @JsonProperty("pri.store.size")
    private String priStoreSize;

    public IndexStatusEntity toEntity(){

        return IndexStatusEntity.builder()
            .index(this.index)
            .health(this.health)
            .status(this.status)
            .docsCount(this.docsCount)
            .build();
    }

}
