package com.arms.api.util.errors;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

@Getter
@RequiredArgsConstructor
public enum ErrorCode {

    SERVER_INFO_ERROR("등록된 서버 정보가 아닙니다."),
    SERVER_URI_INFO_ERROR("서버 URI 정보가 없습니다."),
    SERVER_ID_INFO_ERROR("서버 사용자 아이디 정보가 없습니다."),
    SERVER_PW_OR_API_TOKEN_INFO_ERROR("서버 비밀번호나 토큰 정보가 없습니다."),
    SERVER_TYPE_INFO_ERROR("서버 유형 정보가 없습니다."),
    SERVER_INFO_CREATION_ERROR("serverInfo 저장에 실패하였습니다."),
    SERVER_INFO_RETRIEVAL_ERROR("serverInfo 조회에 실패하였습니다."),
    SERVER_INDEX_NULL_ERROR("serverInfo 인덱스가 존재하지 않습니다."),
    JIRA_ISSUE_INDEX_NULL_ERROR("지라이슈 인덱스가 존재하지 않습니다."),
    JIRA_ISSUE_INDEX_BACKUP_ERROR("지라이슈 인덱스 백업에 실패하였습니다."),
    JIRA_ISSUE_INDEX_DELETION_ERROR("지라이슈 인덱스 삭제에 실패하였습니다."),

    PARAMETER_SERVER_ID_MISSING("파라미터 서버 아이디가 없습니다."),
    PARAMETER_NULL_ERROR("파라미터 정보가 비어있습니다."),
    SEARCH_INFO_ERROR("조회 대상 정보가 없습니다."), // 이슈 및 프로젝트 아이디 및 키 조회시 오류

    REQUESTED_DATA_INVALID("호출 된 '객체' 혹은 '파라미터' 데이터 값이 유효하지 않습니다."),
    REQUEST_BODY_ERROR_CHECK("요청 본문이 없거나 JSON 형식이 아닙니다."), // 이슈 생성 및 수정 관련 오류

    API_PATH_ERROR("잘못된 주소로 요청하였습니다."),   // 경로 오류

    USER_INFO_RETRIEVAL_FAILURE("클라우드 사용자 정보 조회(보고자와 할당자)를 실패하였습니다."),

    PROJECT_RETRIEVAL_ERROR("프로젝트 정보 가져오기에 실패하였습니다. 조회 대상 정보 확인이 필요합니다."),

    ISSUE_CREATION_ERROR("이슈 생성시 오류 발생하여 이슈 생성에 실패하였습니다."),
    ISSUE_MODIFICATION_ERROR("이슈 수정시 오류가 발생하였습니다. 수정 대상 정보 확인이 필요합니다."),
    ISSUE_TRANSITION_ERROR("이슈 상태 변경 시 오류가 발생하였습니다."), // 이슈 상태 변경 (지라: status id -> transition 조회 및 transition id로 상태 변경)

    ISSUE_RETRIEVAL_ERROR("이슈 정보 가져오기에 실패하였습니다. 조회 대상 정보 확인이 필요합니다."),
    ISSUE_TYPE_RETRIEVAL_ERROR("이슈 유형 정보 가져오기에 실패하였습니다."),
    ISSUE_STATUS_RETRIEVAL_ERROR("이슈 상태 정보 가져오기에 실패하였습니다."),
    ISSUE_RESOLUTION_RETRIEVAL_ERROR("이슈 해결책 정보 가져오기에 실패하였습니다."),
    ISSUE_PRIORITY_RETRIEVAL_ERROR("우선순위 정보 가져오기에 실패하였습니다."),
    WORKLOG_RETRIEVAL_ERROR("워크로그 정보 가져오기에 실패하였습니다."),
    ISSUE_TRANSITION_RETRIEVAL_ERROR("이슈 상태 변경을 위한 Transition 조회에 실패하였습니다."),

    ACCOUNT_INFO_RETRIEVAL_ERROR("계정 정보 조회에 실패하였습니다. 토큰및 아이디 정보 확인이 필요합니다."),

    DOCUMENT_NULL_ERROR("Document가 Null입니다.")
    ;

    private final String errorMsg;

    public String getErrorMsg(Object... arg) {
        return String.format(errorMsg, arg);
    }
}
