package com.arms.api.issue.status.strategy;

import com.arms.api.issue.status.vo.CloudJiraByIssueTypeIssueStatusVO;
import com.arms.api.issue.status.vo.IssueStatusVO;
import com.arms.api.serverinfo.model.ServerInfo;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class IssueStatusStrategyFactory {

    IssueStatusStrategy issueStatusStrategy;

    public void registerIssueStatusStrategy(IssueStatusStrategy issueStatusStrategy) {
        this.issueStatusStrategy = issueStatusStrategy;
    }

    public List<IssueStatusVO> getIssueStatusList(ServerInfo serverInfo) {
        return this.issueStatusStrategy.getIssueStatusList(serverInfo);
    }

    public List<CloudJiraByIssueTypeIssueStatusVO> getIssueStatusListByProject(ServerInfo serverInfo,
                                                                               String projectId) {
        return this.issueStatusStrategy.getIssueStatusListByProject(serverInfo, projectId);
    }
}
