package com.arms.api.backoffice.information.timeoff.service;

import com.arms.api.backoffice.information.timeoff.modal.vo.UsersInfoVO;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.egovframework.javaservice.esframework.model.dto.request.AggregationRequestDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SubGroupFieldDTO;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentAggregations;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentBucket;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.*;

@Slf4j
@Service
@AllArgsConstructor
public class TimeOffServiceImpl implements TimeOffService {

    private final EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper;

    private ServerInfoService serverInfoService;

    @Override
    public List<UsersInfoVO> getUsersInfo(){
        Map<String, String> serverIdToTypeMap = serverInfoService.getServerIdToTypeMap();
        DocumentAggregations documentAggregations = esCommonRepositoryWrapper.aggregateRecentDocs(
                SimpleQuery.aggregation(
                    AggregationRequestDTO.builder()
                            .mainField("assignee.assignee_emailAddress.keyword")
                            .mainFieldAlias("emailAddress")
                            .addGroup(
                                SubGroupFieldDTO.builder()
                                        .subFieldAlias("jiraServerId")
                                        .subField("jira_server_id")
                                        .build()
                                ,
                                SubGroupFieldDTO.builder()
                                        .subFieldAlias("displayName")
                                        .subField("assignee.assignee_displayName.keyword")
                                        .build()
                                ,
                                SubGroupFieldDTO.builder()
                                        .subFieldAlias("accountId")
                                        .subField("assignee.assignee_accountId.keyword")
                                        .build()
                            )
                        .build()
                ).andExistsQueryFilter("assignee")
        );

        List<DocumentBucket> deepestList = documentAggregations.deepestList();

        Set<UsersInfoVO> userList = new HashSet<>();

        if (documentAggregations.getTotalHits() == 0) {
            log.info("[ Time Off ServiceImpl :: 작업자_목록_가져오기 ] :: 작업자 정보가 없습니다. 사이즈 => 0");
        }else{

            for (DocumentBucket documentBucket : deepestList) {

                UsersInfoVO user = new UsersInfoVO();

                user.setEmailAddress(documentBucket.valueByName("emailAddress"));

                user.setServerType(serverIdToTypeMap.get(documentBucket.valueByName("jiraServerId")));

                user.setDisplayName(documentBucket.valueByName("displayName"));

                user.setAccountId(documentBucket.valueByName("accountId"));

                userList.add(user);
            }

        }

        if(userList.isEmpty()) {
            return new ArrayList<>(Collections.emptyList());
        } else {
            return new ArrayList<>(userList);
        }
    }
}
