package com.arms.api.backoffice.information.timeoff.controller;

import com.arms.api.backoffice.information.timeoff.modal.vo.UsersInfoVO;
import com.arms.api.backoffice.information.timeoff.service.TimeOffService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Slf4j
@RestController
@RequestMapping("/engine/backoffice/timeoff")
@AllArgsConstructor
public class TimeOffController {
    private final TimeOffService timeoffService;

    @GetMapping("/getUsersInfo")
    public ResponseEntity<List<UsersInfoVO>> getUsersInfo() {
        log.info("[ TimeOffController :: getUserInfo ] :: get users info");
        List<UsersInfoVO> userInfo = timeoffService.getUsersInfo();
        return ResponseEntity.ok(userInfo);
    }
}
