package com.arms.egovframework.javaservice.esframework.repository.common;

import com.arms.egovframework.javaservice.esframework.model.vo.CatIndexVO;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentAggregations;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentResultWrapper;

import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.repository.ElasticsearchRepository;
import org.springframework.data.repository.NoRepositoryBean;

import java.io.Serializable;
import java.util.List;

@NoRepositoryBean
public interface EsCommonRepository<T, U extends Serializable> extends ElasticsearchRepository<T, U> {

	DocumentAggregations aggregateRecentDocs(Query query);

	DocumentAggregations aggregateDocs(Query query);

	DocumentResultWrapper<T> findAllHits();

	DocumentResultWrapper<T> findRecentAllHits();

	DocumentResultWrapper<T> findRecentHits(Query query);

	DocumentResultWrapper<T> findHits(Query query);

	<S extends T> S  save(S entity);

	<S extends T> S  modifyWithIndexName(S entity,String indexName);

	<S extends T> S saveEmpty(S entity);

	<S extends T> Iterable<S> saveAll(Iterable<S> entities);

	List<T> findDocsByScrollApi(Query query);

	DocumentResultWrapper<T> findRecentDocsBySearchAfter(Query query, List<Object> searchAfter);

	DocumentResultWrapper<T> findDocsBySearchAfter(Query query, List<Object> searchAfter);

	String indexAliasName();

	String deleteDocByEntity(T t);

	List<T> findRecentDocsByScrollApi(Query query);

	T findRecentDocByRecentId(U u);

	U deleteRecentDocById(U u);

	DocumentResultWrapper<T> findRecentDocById(U u);

	T findDocById(U u);

	void mergeWithReindex(int day);

	void deleteIndexWithDayRange(int day);

	List<CatIndexVO> catIndexVOList();

	Long indexCount();

}
